/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.report;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.jbpm.sim.def.DistributionDefinition;
import org.jbpm.sim.report.dto.BaseResult;
import org.jbpm.sim.report.dto.CountResult;
import org.jbpm.sim.report.dto.QueueStatisticsResult;
import org.jbpm.sim.report.dto.TimeSeriesResult;
import org.jbpm.sim.report.dto.UtilizationStatisticsResult;
import org.jbpm.sim.report.dto.ValueStatisticResult;

public class ScenarioReport {
    private String scenarioName;
    private double simulationRunTime;
    private double resetTime;
    private Map stateWaitingTimes = new HashMap();
    private Map cycleTimesValueStatistics = new HashMap();
    private Map miscValueStatistics = new HashMap();
    private Map resourcePoolWaitingTimes = new HashMap();
    private Map resourcePoolUtilizations = new HashMap();
    private Map miscQueueStatistics = new HashMap();
    private Map resourcePoolTimeSeries = new HashMap();
    private Map distributionDefinitions = new HashMap();
    private Map businessFigureValues = new HashMap();
    private Map processEndCounts = new HashMap();
    private Map processStartCounts = new HashMap();

    public void addStateWaitStatistics(ValueStatisticResult vsr) {
        this.stateWaitingTimes.put(vsr.getName(), vsr);
    }

    public void addProcessCycleTimeStatistics(ValueStatisticResult vsr) {
        this.cycleTimesValueStatistics.put(vsr.getName(), vsr);
    }

    public void addMiscValueStatistics(ValueStatisticResult vsr) {
        this.miscValueStatistics.put(vsr.getName(), vsr);
    }

    public void addResourcePoolWaitingTimes(QueueStatisticsResult qsr) {
        this.resourcePoolWaitingTimes.put(qsr.getName(), qsr);
    }

    public void addMiscQueueStatistics(QueueStatisticsResult qsr) {
        this.miscQueueStatistics.put(qsr.getName(), qsr);
    }

    public void addResourcePoolUtilization(BaseResult usr) {
        this.resourcePoolUtilizations.put(usr.getName(), usr);
    }

    public void addResourcePoolTimeSeries(TimeSeriesResult timeSeriesReport) {
        this.resourcePoolTimeSeries.put(timeSeriesReport.getName(), timeSeriesReport);
    }

    public void addDistributionDefinition(DistributionDefinition o) {
        this.distributionDefinitions.put(o.getName(), o);
    }

    public void addProcessEndCount(CountResult countResult) {
        this.processEndCounts.put(countResult.getName(), countResult);
    }

    public void addProcessStartCount(CountResult countResult) {
        this.processStartCounts.put(countResult.getName(), countResult);
    }

    public void setScenarioName(String name) {
        this.scenarioName = name;
    }

    public Document createDocument() {
        throw new RuntimeException("create xml document of simulation statistics not yet implemented");
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public void addBusinessFigure(String type, double sum) {
        this.businessFigureValues.put(type, sum);
    }

    public void calculateResourceCosts(double unutilizedTimeCostFactor) {
        for (UtilizationStatisticsResult util : this.getResourcePoolUtilizations()) {
            util.calculateCosts(unutilizedTimeCostFactor, this.simulationRunTime);
        }
    }

    public Collection getBusinessFigureTypes() {
        return this.businessFigureValues.keySet();
    }

    public double getBusinessFigureValue(String type) {
        return (Double)this.businessFigureValues.get(type);
    }

    public double getCost() {
        return this.getCosts();
    }

    public double getCosts() {
        double result = this.getResourceCosts();
        for (String type : this.getBusinessFigureTypes()) {
            if (!"costs".equals(type)) continue;
            result += this.getBusinessFigureValue(type);
        }
        return result;
    }

    public double getResourceCosts() {
        double result = 0.0;
        for (UtilizationStatisticsResult util : this.getResourcePoolUtilizations()) {
            result += util.getCosts();
        }
        return result;
    }

    public QueueStatisticsResult getWorstAverageResourceWaitingTime() {
        QueueStatisticsResult result = null;
        for (QueueStatisticsResult stat : this.getResourcePoolWaitingTimes()) {
            if (result != null && !(stat.getAverageWaitTime() > result.getAverageWaitTime())) continue;
            result = stat;
        }
        return result;
    }

    public double getAverageResourceUtilization() {
        double utilization = 0.0;
        int observations = 0;
        for (UtilizationStatisticsResult util : this.getResourcePoolUtilizations()) {
            utilization += util.getAverageUtilization() * (double)util.getPoolSize();
            observations += util.getPoolSize();
        }
        return utilization / (double)observations;
    }

    public int getResourceAmount() {
        int result = 0;
        for (UtilizationStatisticsResult util : this.getResourcePoolUtilizations()) {
            result += util.getPoolSize();
        }
        return result;
    }

    public DistributionDefinition getDistributionDefinition(String name) {
        return (DistributionDefinition)this.distributionDefinitions.get(name);
    }

    public double getSimulationRunTime() {
        return this.simulationRunTime;
    }

    public void setSimulationRunTime(double simulationRunTime) {
        this.simulationRunTime = simulationRunTime;
    }

    public Collection getStateWaitingTimes() {
        return this.stateWaitingTimes.values();
    }

    public ValueStatisticResult getStateWaitingTimes(String name) {
        return (ValueStatisticResult)this.stateWaitingTimes.get(name);
    }

    public Collection getCycleTimesValueStatistics() {
        return this.cycleTimesValueStatistics.values();
    }

    public ValueStatisticResult getCycleTimesValueStatistics(String name) {
        return (ValueStatisticResult)this.cycleTimesValueStatistics.get(name);
    }

    public Collection getMiscValueStatistics() {
        return this.miscValueStatistics.values();
    }

    public ValueStatisticResult getMiscValueStatistics(String name) {
        return (ValueStatisticResult)this.miscValueStatistics.get(name);
    }

    public Collection getDistributionDefinitions() {
        return this.distributionDefinitions.values();
    }

    public Collection getResourcePoolWaitingTimes() {
        return this.resourcePoolWaitingTimes.values();
    }

    public QueueStatisticsResult getResourcePoolWaitingTimes(String name) {
        return (QueueStatisticsResult)this.resourcePoolWaitingTimes.get(name);
    }

    public Collection getResourcePoolUtilizations() {
        return this.resourcePoolUtilizations.values();
    }

    public UtilizationStatisticsResult getResourcePoolUtilization(String name) {
        return (UtilizationStatisticsResult)this.resourcePoolUtilizations.get(name);
    }

    public Collection getMiscQueueStatistics() {
        return this.miscQueueStatistics.values();
    }

    public QueueStatisticsResult getMiscQueueStatistics(String name) {
        return (QueueStatisticsResult)this.miscQueueStatistics.get(name);
    }

    public Collection getResourcePoolTimeSeries() {
        return this.resourcePoolTimeSeries.values();
    }

    public TimeSeriesResult getResourcePoolTimeSeries(String name) {
        return (TimeSeriesResult)this.resourcePoolTimeSeries.get(name);
    }

    public TimeSeriesResult getResourcePoolTimeSeriesResult(String poolName) {
        TimeSeriesResult result = (TimeSeriesResult)this.resourcePoolTimeSeries.get(poolName);
        if (result == null) {
            return new TimeSeriesResult(poolName, this.scenarioName, new double[0], new double[0]);
        }
        return result;
    }

    public Map getProcessEndCounts() {
        return this.processEndCounts;
    }

    public CountResult getProcessEndCount(String name) {
        return (CountResult)this.processEndCounts.get(name);
    }

    public Map getProcessStartCounts() {
        return this.processStartCounts;
    }

    public CountResult getProcessStartCount(String name) {
        return (CountResult)this.processStartCounts.get(name);
    }

    public double getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(double resetTime) {
        this.resetTime = resetTime;
    }
}

