/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.entity;

import desmoj.core.simulator.Model;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.Token;
import org.jbpm.sim.def.ResourceRequirement;
import org.jbpm.sim.entity.ResourceUsingEntity;
import org.jbpm.sim.event.WorkCompletionEvent;

public class TokenEntity
extends ResourceUsingEntity {
    private static Log log = LogFactory.getLog(TokenEntity.class);
    private Token token;

    public Token getToken() {
        return this.token;
    }

    public TokenEntity(Model owner, Token token) {
        super(owner, "Token " + token + " in state " + token.getNode(), true);
        this.token = token;
    }

    public Object getEntityObject() {
        return this.token.getNode();
    }

    protected void doStart() {
        this.scheduleCompletion();
    }

    public void scheduleCompletion() {
        log.info((Object)("ask the simulation clock to signal token " + this.token + " whenever it feels like it"));
        WorkCompletionEvent evt = new WorkCompletionEvent(this.getModel());
        evt.schedule(this, this.getJbpmModel().getStateWorkingTime(this.token.getNode()));
    }

    protected ResourceRequirement[] getRequiredResources() {
        return this.getJbpmModel().getResourceRequirements(this.token.getNode());
    }

    public void doEnd() {
        this.token.signal(this.getJbpmModel().getLeavingTransition(this.token.getNode()));
    }
}

