/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.exe;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.jpdl.xml.JpdlParser;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.sim.datasource.UseDataFilterAction;
import org.jbpm.sim.datasource.UseDataSourceAction;
import org.jbpm.sim.def.DistributionDefinition;
import org.jbpm.sim.def.JbpmSimulationExperiment;
import org.jbpm.sim.def.JbpmSimulationScenario;
import org.jbpm.sim.exception.ExperimentConfigurationException;
import org.jbpm.sim.jpdl.SimulationDefinition;
import org.jbpm.sim.jpdl.SimulationJpdlXmlReader;
import org.jbpm.sim.kpi.BusinessFigure;
import org.jbpm.sim.kpi.BusinessFigureAction;
import org.jbpm.taskmgmt.def.Task;
import org.xml.sax.InputSource;

public class ExperimentReader
implements ProblemListener {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog((Class)ExperimentReader.class);
    private InputSource inputSource = null;
    protected Document experimentDoc;
    private JbpmSimulationExperiment experiment;
    private Map processDefinitionRepository = new HashMap();

    public ExperimentReader(String experimentXml) {
        this(new InputSource(new StringReader(experimentXml)));
    }

    public ExperimentReader(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    protected Document getXmlDocument() {
        if (this.experimentDoc == null) {
            try {
                this.experimentDoc = JpdlParser.parse((InputSource)this.inputSource, (ProblemListener)this);
            }
            catch (Exception e) {
                throw new ExperimentConfigurationException("Couldn't read experiment XML", e);
            }
        }
        return this.experimentDoc;
    }

    public void addProblem(Problem problem) {
        log.warn((Object)("problem occured while parsing XML: " + problem));
    }

    public void addProcessDefinition(String processName, String processXml) {
        this.processDefinitionRepository.put(processName, processXml);
    }

    public JbpmSimulationExperiment readExperiment() {
        Element outputElement;
        Element root = this.getXmlDocument().getRootElement();
        String name = root.attributeValue("name");
        this.experiment = new JbpmSimulationExperiment(name);
        String runTimeString = root.attributeValue("run-time");
        String resetTime = root.attributeValue("reset-time");
        String realStartTimeString = root.attributeValue("real-start-time");
        String timeUnitString = root.attributeValue("time-unit");
        String currencyString = root.attributeValue("currency");
        String unutilizedTimeCostFactorString = root.attributeValue("unutilized-time-cost-factor");
        if (currencyString != null) {
            this.experiment.setCurrency(currencyString);
        }
        if (unutilizedTimeCostFactorString != null) {
            this.experiment.setUnutilizedTimeCostFactor(Double.parseDouble(unutilizedTimeCostFactorString));
        }
        if (runTimeString != null) {
            this.experiment.setSimulationRunTime(Double.parseDouble(runTimeString));
        }
        if (resetTime != null) {
            this.experiment.setResetTime(Double.parseDouble(resetTime));
        }
        if (realStartTimeString != null) {
            this.experiment.setRealStartDate(realStartTimeString);
        }
        if (timeUnitString != null) {
            if ("millisecond".equals(timeUnitString = timeUnitString.toLowerCase())) {
                this.experiment.setTimeUnit(JbpmSimulationExperiment.MILLISECONDS);
            } else if ("second".equals(timeUnitString)) {
                this.experiment.setTimeUnit(JbpmSimulationExperiment.SECONDS);
            } else if ("minute".equals(timeUnitString)) {
                this.experiment.setTimeUnit(JbpmSimulationExperiment.MINUTES);
            } else if ("hour".equals(timeUnitString)) {
                this.experiment.setTimeUnit(JbpmSimulationExperiment.HOURS);
            }
        }
        if ((outputElement = root.element("output")) != null) {
            String outputPathName = outputElement.attributeValue("path");
            this.experiment.setOutputPathName(outputPathName);
        }
        Iterator scenarioIterator = root.elementIterator("scenario");
        while (scenarioIterator.hasNext()) {
            Element scenarioElement = (Element)scenarioIterator.next();
            String baseScenario = scenarioElement.attributeValue("base-scenario");
            if (baseScenario != null) {
                Element baseScenarioElement = null;
                Iterator iter2 = root.elementIterator("scenario");
                while (iter2.hasNext()) {
                    Element e = (Element)iter2.next();
                    if (!baseScenario.equals(e.attributeValue("name"))) continue;
                    baseScenarioElement = e;
                    break;
                }
                if (baseScenarioElement == null) {
                    throw new ExperimentConfigurationException("base scenario with name '" + baseScenario + "' does not exist");
                }
                this.addScenario(this.readScenario(scenarioElement, baseScenarioElement));
                continue;
            }
            this.addScenario(this.readScenario(scenarioElement, null));
        }
        JbpmSimulationExperiment result = this.experiment;
        this.experiment = null;
        return result;
    }

    protected void addScenario(JbpmSimulationScenario scenario) {
        this.experiment.addScenario(scenario);
    }

    public static DistributionDefinition readDistribution(Element distributionElement) {
        String name = distributionElement.attributeValue("name");
        String sampleType = distributionElement.attributeValue("sample-type");
        String type = distributionElement.attributeValue("type");
        String valueText = distributionElement.attributeValue("value");
        String meanText = distributionElement.attributeValue("mean");
        String standardDeviationText = distributionElement.attributeValue("standardDeviation");
        String minText = distributionElement.attributeValue("min");
        String maxText = distributionElement.attributeValue("max");
        String nonNegativeText = distributionElement.attributeValue("nonNegative");
        boolean nonNegative = "true".equals(nonNegativeText) || "yes".equals(nonNegativeText);
        return new DistributionDefinition(name, type, sampleType, valueText, meanText, standardDeviationText, minText, maxText, nonNegative);
    }

    protected JbpmSimulationScenario readScenario(Element scenarioElement, Element baseScenarioElement) {
        String name = scenarioElement.attributeValue("name");
        JbpmSimulationScenario scenario = new JbpmSimulationScenario(name);
        String execute = scenarioElement.attributeValue("execute");
        if ("false".equalsIgnoreCase(execute) || "no".equalsIgnoreCase(execute)) {
            scenario.setExecute(false);
        }
        this.beforeScenarioRead(scenario, scenarioElement, baseScenarioElement);
        if (baseScenarioElement != null) {
            this.readScenarioContent(baseScenarioElement, scenario);
        }
        this.readScenarioContent(scenarioElement, scenario);
        this.afterScenarioRead(scenario, scenarioElement, baseScenarioElement);
        return scenario;
    }

    protected void afterScenarioRead(JbpmSimulationScenario scenario, Element scenarioElement, Element baseScenarioElement) {
    }

    protected void beforeScenarioRead(JbpmSimulationScenario scenario, Element scenarioElement, Element baseScenarioElement) {
    }

    private void readScenarioContent(Element scenarioElement, JbpmSimulationScenario scenario) {
        Iterator processIterator = scenarioElement.elementIterator("sim-process");
        while (processIterator.hasNext()) {
            Element processElement = (Element)processIterator.next();
            this.readSimProcess(scenario, processElement);
        }
        Iterator distributionIterator = scenarioElement.elementIterator("distribution");
        while (distributionIterator.hasNext()) {
            Element distributionElement = (Element)distributionIterator.next();
            DistributionDefinition distDef = ExperimentReader.readDistribution(distributionElement);
            scenario.addDistribution(distDef);
        }
        Iterator poolElementIter = scenarioElement.elementIterator("resource-pool");
        while (poolElementIter.hasNext()) {
            Element resourcePoolElement = (Element)poolElementIter.next();
            String poolName = resourcePoolElement.attributeValue("name");
            String poolSizeText = resourcePoolElement.attributeValue("pool-size");
            Integer poolSize = new Integer(poolSizeText);
            scenario.addResourcePool(poolName, poolSize, this.readCostPerTimeUnit(resourcePoolElement));
        }
        Iterator businessFigureIterator = scenarioElement.elementIterator("business-figure");
        while (businessFigureIterator.hasNext()) {
            Element figureElement = (Element)businessFigureIterator.next();
            BusinessFigure figure = new BusinessFigure(figureElement.attributeValue("name"), figureElement.attributeValue("type"), figureElement.attributeValue("handler"), figureElement.attributeValue("expression"));
            scenario.addBusinessFigure(figure);
        }
        Iterator dataSourceIterator = scenarioElement.elementIterator("data-source");
        while (dataSourceIterator.hasNext()) {
            Element dataSource = (Element)dataSourceIterator.next();
            scenario.addDataSource(dataSource.attributeValue("name"), dataSource.attributeValue("handler"));
        }
        Iterator dataFilterIterator = scenarioElement.elementIterator("data-filter");
        while (dataFilterIterator.hasNext()) {
            Element dataFilter = (Element)dataFilterIterator.next();
            scenario.addDataFilter(dataFilter.attributeValue("name"), dataFilter.attributeValue("handler"));
        }
    }

    protected Double readCostPerTimeUnit(Element resourcePoolElement) {
        String costPerTimeUnitText = resourcePoolElement.attributeValue("costs-per-time-unit");
        if (costPerTimeUnitText != null) {
            return Double.valueOf(costPerTimeUnitText);
        }
        return new Double(0.0);
    }

    private void readSimProcess(JbpmSimulationScenario scenario, Element processElement) {
        SimulationJpdlXmlReader processReader;
        String processName = processElement.attributeValue("name");
        String processPath = processElement.attributeValue("path");
        ProcessDefinition pd = null;
        if (processName != null && this.processDefinitionRepository.containsKey(processName)) {
            String processXml = (String)this.processDefinitionRepository.get(processName);
            processReader = new SimulationJpdlXmlReader(processXml);
            pd = processReader.readProcessDefinition();
        } else if (processPath != null) {
            InputSource source = new InputSource(this.getClass().getResourceAsStream(processPath));
            processReader = new SimulationJpdlXmlReader(source);
            pd = processReader.readProcessDefinition();
        } else {
            throw new ExperimentConfigurationException("references process (name='" + processName + "', path='" + processPath + "') in scenario '" + scenario.getName() + "' not found.");
        }
        Iterator processIter = processElement.elementIterator("process-overwrite");
        while (processIter.hasNext()) {
            this.readProcessOverwrite(pd, (Element)processIter.next());
        }
        Iterator stateIter = processElement.elementIterator("state-overwrite");
        while (stateIter.hasNext()) {
            this.readStateOverwrite(pd, (Element)stateIter.next());
        }
        Iterator decisionIter = processElement.elementIterator("decision-overwrite");
        while (decisionIter.hasNext()) {
            this.readDecisionOverwrite(pd, (Element)decisionIter.next());
        }
        Iterator taskIter = processElement.elementIterator("task-overwrite");
        while (taskIter.hasNext()) {
            this.readTaskOverwrite(pd, (Element)taskIter.next());
        }
        Iterator nodeIter = processElement.elementIterator("node-overwrite");
        while (nodeIter.hasNext()) {
            this.readNodeOverwrite(pd, (Element)nodeIter.next());
        }
        scenario.addProcessDefinition(pd);
    }

    private void readProcessOverwrite(ProcessDefinition pd, Element e) {
        String newStartDistribution = e.attributeValue("start-distribution");
        if (newStartDistribution != null) {
            ((SimulationDefinition)pd.getDefinition(SimulationDefinition.class)).setStartDistribution(newStartDistribution);
        }
        this.readUseDataSourceEvent((GraphElement)pd.getStartState(), e, "before-signal");
    }

    private void readStateOverwrite(ProcessDefinition pd, Element e) {
        String stateName = e.attributeValue("state-name");
        String newDistribution = e.attributeValue("time-distribution");
        SimulationDefinition sd = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
        Node node = pd.getNode(stateName);
        if (newDistribution != null) {
            sd.addStateDistribution(node, newDistribution);
        }
        this.readUseDataSourceEvent((GraphElement)node, e, "node-enter");
        this.readUseDataFilterEvent((GraphElement)node, e, "node-enter");
        this.readBusinessFigureEvent((GraphElement)node, e, "node-enter");
        Iterator iter = e.elementIterator("transition");
        while (iter.hasNext()) {
            this.readTransitionOverwrite(sd, node, (Element)iter.next());
        }
    }

    private void readNodeOverwrite(ProcessDefinition pd, Element e) {
        String nodeName = e.attributeValue("node-name");
        Node node = pd.getNode(nodeName);
        this.readUseDataSourceEvent((GraphElement)node, e, "node-enter");
        this.readUseDataFilterEvent((GraphElement)node, e, "node-enter");
        this.readBusinessFigureEvent((GraphElement)node, e, "node-enter");
    }

    private void readDecisionOverwrite(ProcessDefinition pd, Element e) {
        String decisionName = e.attributeValue("decision-name");
        SimulationDefinition sd = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
        Node node = pd.getNode(decisionName);
        Iterator iter = e.elementIterator("transition");
        while (iter.hasNext()) {
            this.readTransitionOverwrite(sd, node, (Element)iter.next());
        }
    }

    private void readTaskOverwrite(ProcessDefinition pd, Element e) {
        String taskName = e.attributeValue("task-name");
        String newDistribution = e.attributeValue("time-distribution");
        SimulationDefinition sd = (SimulationDefinition)pd.getDefinition(SimulationDefinition.class);
        Task task = pd.getTaskMgmtDefinition().getTask(taskName);
        if (newDistribution != null) {
            sd.addTaskDistribution(task, newDistribution);
        }
        this.readUseDataSourceEvent((GraphElement)task.getTaskNode(), e, "node-enter");
        this.readUseDataFilterEvent((GraphElement)task.getTaskNode(), e, "node-enter");
        this.readBusinessFigureEvent((GraphElement)task.getTaskNode(), e, "node-enter");
        Iterator iter = e.elementIterator("transition");
        while (iter.hasNext()) {
            this.readTransitionOverwrite(sd, (Node)task.getTaskNode(), (Element)iter.next());
        }
    }

    private void readUseDataSourceEvent(GraphElement graphElement, Element xmlElement, String eventtype) {
        Element e = xmlElement.element("use-data-source");
        if (e != null) {
            Event evt = new Event(eventtype);
            UseDataSourceAction action = new UseDataSourceAction();
            action.setName(e.attributeValue("name"));
            evt.addAction((Action)action);
            graphElement.addEvent(evt);
        }
    }

    private void readUseDataFilterEvent(GraphElement graphElement, Element xmlElement, String eventtype) {
        Element e = xmlElement.element("use-data-filter");
        if (e != null) {
            Event evt = new Event(eventtype);
            UseDataFilterAction action = new UseDataFilterAction();
            action.setName(e.attributeValue("name"));
            evt.addAction((Action)action);
            graphElement.addEvent(evt);
        }
    }

    private void readBusinessFigureEvent(GraphElement graphElement, Element xmlElement, String eventtype) {
        Element e = xmlElement.element("calculate-business-figure");
        if (e != null) {
            Event evt = new Event(eventtype);
            BusinessFigureAction action = new BusinessFigureAction();
            action.setName(e.attributeValue("name"));
            evt.addAction((Action)action);
            graphElement.addEvent(evt);
        }
    }

    private void readTransitionOverwrite(SimulationDefinition sd, Node node, Element transitionElement) {
        String name = transitionElement.attributeValue("name");
        Transition trans = node.getLeavingTransition(name);
        String probString = transitionElement.attributeValue("probability");
        if (probString != null) {
            double prob = Double.parseDouble(probString);
            sd.addTransitionProbability(trans, prob);
        }
    }
}

