/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.Group;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class LoadGroupByNameActionListener
implements JbpmActionListener {
    private final ValueExpression groupNameExpression;
    private final ValueExpression targetExpression;

    public LoadGroupByNameActionListener(ValueExpression groupNameExpression, ValueExpression targetExpression) {
        this.groupNameExpression = groupNameExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "loadGroupByName";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object nameValue = this.groupNameExpression.getValue(elContext);
            IdentitySession identitySession = new IdentitySession(context.getJbpmContext().getSession());
            if (nameValue == null) {
                context.setError("Error loading group", "The group name value is null");
                return;
            }
            String groupName = nameValue.toString();
            Group group = identitySession.getGroupByName(groupName);
            if (group == null) {
                context.setError("Error loading group", "No group was found named '" + groupName + "'");
                return;
            }
            this.targetExpression.setValue(elContext, (Object)group);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading group", ex);
            return;
        }
    }
}

