/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GetDiagramInfoActionListener
implements JbpmActionListener {
    private final ValueExpression processExpression;
    private final ValueExpression targetExpression;

    public GetDiagramInfoActionListener(ValueExpression processExpression, ValueExpression targetExpression) {
        this.processExpression = processExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "getDiagramInfo";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            ProcessDefinition processDefinition;
            FileDefinition fileDefinition;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object processValue = this.processExpression.getValue(elContext);
            if (processValue == null) {
                context.setError("Error getting diagram info", "The process value is null");
                return;
            }
            if (!(processValue instanceof ProcessDefinition)) {
                context.setError("Error getting diagram info", "The process value is not of type ProcessDefinition");
            }
            if (!(fileDefinition = (processDefinition = (ProcessDefinition)processValue).getFileDefinition()).hasFile("gpd.xml")) {
                this.targetExpression.setValue(elContext, null);
                context.selectOutcome("success");
                return;
            }
            Document document = XmlUtil.parseXmlInputStream((InputStream)fileDefinition.getInputStream("gpd.xml"));
            Element processDiagramElement = document.getDocumentElement();
            String widthString = processDiagramElement.getAttribute("width");
            String heightString = processDiagramElement.getAttribute("height");
            ArrayList<DiagramNodeInfo> diagramNodeInfoList = new ArrayList<DiagramNodeInfo>();
            NodeList nodeNodeList = processDiagramElement.getElementsByTagName("node");
            int nodeNodeListLength = nodeNodeList.getLength();
            for (int i = 0; i < nodeNodeListLength; ++i) {
                Node nodeNode = nodeNodeList.item(i);
                if (nodeNode.getParentNode() != processDiagramElement) continue;
                Element nodeElement = (Element)nodeNode;
                String nodeName = nodeElement.getAttribute("name");
                String nodeXString = nodeElement.getAttribute("x");
                String nodeYString = nodeElement.getAttribute("y");
                String nodeWidthString = nodeElement.getAttribute("width");
                String nodeHeightString = nodeElement.getAttribute("height");
                DiagramNodeInfo nodeInfo = new DiagramNodeInfo(nodeName, Integer.parseInt(nodeXString), Integer.parseInt(nodeYString), Integer.parseInt(nodeWidthString), Integer.parseInt(nodeHeightString));
                diagramNodeInfoList.add(nodeInfo);
            }
            DiagramInfo diagramInfo = new DiagramInfo(Integer.parseInt(heightString), Integer.parseInt(widthString), diagramNodeInfoList);
            this.targetExpression.setValue(elContext, (Object)diagramInfo);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error getting diagram info", ex);
            return;
        }
    }

    public static final class DiagramNodeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public DiagramNodeInfo(String name, int x, int y, int width, int height) {
            this.height = height;
            this.name = name;
            this.width = width;
            this.x = x;
            this.y = y;
        }

        public int getHeight() {
            return this.height;
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DiagramInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int width;
        private final int height;
        private final Map<String, DiagramNodeInfo> nodeMap;

        public DiagramInfo(int height, int width, List<DiagramNodeInfo> nodeList) {
            this.height = height;
            this.width = width;
            LinkedHashMap<String, DiagramNodeInfo> map = new LinkedHashMap<String, DiagramNodeInfo>();
            for (DiagramNodeInfo nodeInfo : nodeList) {
                map.put(nodeInfo.getName(), nodeInfo);
            }
            this.nodeMap = Collections.unmodifiableMap(map);
        }

        public int getHeight() {
            return this.height;
        }

        public Map<String, DiagramNodeInfo> getNodeMap() {
            return this.nodeMap;
        }

        public List<DiagramNodeInfo> getNodes() {
            return Collections.unmodifiableList(new ArrayList<DiagramNodeInfo>(this.nodeMap.values()));
        }

        public int getWidth() {
            return this.width;
        }
    }
}

