/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class StartTaskActionListener
implements JbpmActionListener {
    private final ValueExpression taskInstanceExpression;
    private final ValueExpression actorIdExpression;
    private final ValueExpression overwriteSwimlaneExpression;

    public StartTaskActionListener(ValueExpression taskInstanceExpression, ValueExpression actorIdExpression, ValueExpression overwriteSwimlaneExpression) {
        this.taskInstanceExpression = taskInstanceExpression;
        this.actorIdExpression = actorIdExpression;
        this.overwriteSwimlaneExpression = overwriteSwimlaneExpression;
    }

    public String getName() {
        return "startTask";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object taskInstanceValue = this.taskInstanceExpression.getValue(elContext);
            if (taskInstanceValue == null) {
                context.setError("Error starting task", "The task instance value is null");
                return;
            }
            if (!(taskInstanceValue instanceof TaskInstance)) {
                context.setError("Error starting task", "Attempted to start something other than a task instance");
                return;
            }
            TaskInstance taskInstance = (TaskInstance)taskInstanceValue;
            if (this.actorIdExpression != null) {
                Object actorIdValue = this.actorIdExpression.getValue(elContext);
                if (actorIdValue == null) {
                    context.setError("Error starting task", "Actor ID expression resolved to null");
                    return;
                }
                String actorId = actorIdValue.toString();
                if (this.overwriteSwimlaneExpression != null) {
                    Object overwriteSwimlaneValue = this.overwriteSwimlaneExpression.getValue(elContext);
                    if (overwriteSwimlaneValue == null) {
                        context.setError("Error starting task", "Overwrite swimlane expression resolved to null");
                        return;
                    }
                    Boolean overwriteSwimlane = overwriteSwimlaneValue instanceof Boolean ? (Boolean)overwriteSwimlaneValue : Boolean.valueOf(overwriteSwimlaneValue.toString());
                    taskInstance.start(actorId, overwriteSwimlane.booleanValue());
                } else {
                    taskInstance.start(actorId);
                }
            } else {
                taskInstance.start();
            }
            context.addSuccessMessage("Task started");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error starting task", ex);
            return;
        }
    }
}

