/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.phase;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jbpm.jsf.core.impl.JbpmJsfContextImpl;

public final class JbpmPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger("org.jbpm.jsf.core.phase.JbpmPhaseListener");

    public void beforePhase(PhaseEvent phaseEvent) {
        log.fine("Before phase " + phaseEvent.getPhaseId().toString());
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        log.fine("After phase " + phaseEvent.getPhaseId().toString());
        FacesContext facesContext = phaseEvent.getFacesContext();
        JbpmJsfContextImpl jbpmJsfContext = this.getJbpmJsfContext(facesContext);
        if (jbpmJsfContext != null) {
            if (facesContext.getResponseComplete()) {
                this.closeContext(jbpmJsfContext);
                this.removeJbpmJsfContext(facesContext);
            } else if (phaseEvent.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                this.handleOutcome(facesContext, jbpmJsfContext);
                this.closeContext(jbpmJsfContext);
                this.removeJbpmJsfContext(facesContext);
            } else if (phaseEvent.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                this.closeContext(jbpmJsfContext);
                this.removeJbpmJsfContext(facesContext);
            }
        }
    }

    private void commitTxnMessages(FacesContext facesContext, JbpmJsfContextImpl jbpmJsfContext) {
        if (!jbpmJsfContext.isError()) {
            for (FacesMessage msg : jbpmJsfContext.getMessages()) {
                facesContext.addMessage(null, msg);
            }
        }
    }

    private void handleOutcome(FacesContext facesContext, JbpmJsfContextImpl jbpmJsfContext) {
        NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
        if (jbpmJsfContext.isError()) {
            navigationHandler.handleNavigation(facesContext, jbpmJsfContext.getOutcomeActionName(), "error");
        } else {
            String outcome = jbpmJsfContext.getOutcome();
            if (outcome != null) {
                navigationHandler.handleNavigation(facesContext, jbpmJsfContext.getOutcomeActionName(), outcome);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private JbpmJsfContextImpl getJbpmJsfContext(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        return (JbpmJsfContextImpl)requestMap.get("org.jbpm.jsf.CONTEXT");
    }

    private void removeJbpmJsfContext(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.remove("org.jbpm.jsf.CONTEXT");
    }

    private void closeContext(JbpmJsfContextImpl jbpmJsfContext) {
        if (jbpmJsfContext.hasJbpmContext()) {
            log.fine("Closing jBPM context");
            if (jbpmJsfContext.isError()) {
                log.fine("Context has an error status; setting transaction to roll back");
                jbpmJsfContext.getJbpmContext().setRollbackOnly();
            }
            FacesContext context = FacesContext.getCurrentInstance();
            try {
                jbpmJsfContext.getJbpmContext().close();
            }
            catch (RuntimeException ex) {
                try {
                    jbpmJsfContext.getJbpmContext().setRollbackOnly();
                }
                catch (Exception ex2) {
                    log.log(Level.WARNING, "Failed to set rollback on jBPM context after close failed", ex2);
                }
                context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Closing the database context failed", "An exception of type " + ex.getClass().getName() + " was thrown, with the message: " + ex.getMessage()));
                return;
            }
            this.commitTxnMessages(context, jbpmJsfContext);
        }
    }
}

