/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class SignalActionListener
implements JbpmActionListener {
    private final ValueExpression valueExpression;
    private final ValueExpression transitionExpression;

    public SignalActionListener(ValueExpression valueExpression, ValueExpression transitionExpression) {
        this.valueExpression = valueExpression;
        this.transitionExpression = transitionExpression;
    }

    public String getName() {
        return "signal";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            Token token;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object value = this.valueExpression.getValue(elContext);
            if (value == null) {
                context.setError("Signal failed", "The value is null");
                return;
            }
            if (value instanceof Token) {
                token = (Token)value;
            } else if (value instanceof ProcessInstance) {
                token = ((ProcessInstance)value).getRootToken();
            } else {
                context.setError("Signal failed", "The value type is not recognized");
                return;
            }
            if (this.transitionExpression != null) {
                Object transitionValue = this.transitionExpression.getValue(elContext);
                if (transitionValue == null) {
                    token.signal();
                } else if (transitionValue instanceof Transition) {
                    token.signal((Transition)transitionValue);
                } else {
                    token.signal(transitionValue.toString());
                }
            } else {
                token.signal();
            }
            context.addSuccessMessage(value instanceof ProcessInstance ? "Process instance" : "Token signalled");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error signalling token", ex);
        }
    }
}

