/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.jsf.core.impl.UpdatesHashMap;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class GetVariableMapActionListener
implements JbpmActionListener {
    private final ValueExpression valueExpression;
    private final ValueExpression targetExpression;

    public GetVariableMapActionListener(ValueExpression valueExpression, ValueExpression targetExpression) {
        this.valueExpression = valueExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "getVariableMap";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            UpdatesHashMap updatesMap;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object value = this.valueExpression.getValue(elContext);
            if (value instanceof ProcessInstance) {
                ProcessInstance processInstance = (ProcessInstance)value;
                updatesMap = new UpdatesHashMap(processInstance.getContextInstance().getVariables());
            } else if (value instanceof Token) {
                Token token = (Token)value;
                updatesMap = new UpdatesHashMap(token.getProcessInstance().getContextInstance().getVariables(token));
            } else if (value instanceof TaskInstance) {
                TaskInstance task = (TaskInstance)value;
                updatesMap = new UpdatesHashMap(task.getVariables());
            } else {
                if (value == null) {
                    context.setError("Error getting variable map", "The value was given as null");
                    return;
                }
                context.setError("Error getting variable map", "The value is not a recognized type");
                return;
            }
            this.targetExpression.setValue(elContext, (Object)updatesMap);
        }
        catch (Exception ex) {
            context.setError("Error getting variable map", ex);
            return;
        }
    }
}

