/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class AddCommentActionListener
implements JbpmActionListener {
    private final ValueExpression comment;
    private final ValueExpression target;

    public AddCommentActionListener(ValueExpression comment, ValueExpression target) {
        this.comment = comment;
        this.target = target;
    }

    public String getName() {
        return "addComment";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            String commentText;
            String commentAsString;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object commentValue = this.comment.getValue(elContext);
            if (commentValue != null && (commentAsString = commentValue.toString()) != null && !"".equals(commentText = commentAsString.trim())) {
                Object targetValue = this.target.getValue(elContext);
                if (targetValue instanceof Token) {
                    ((Token)targetValue).addComment(commentText);
                } else if (targetValue instanceof TaskInstance) {
                    ((TaskInstance)targetValue).addComment(commentText);
                } else {
                    context.setError("Failed to add comment", "The addComment action target refers to an invalid type");
                    return;
                }
                context.addSuccessMessage("Comment added successfully");
                context.selectOutcome("success");
            }
            context.getJbpmContext().getSession().flush();
        }
        catch (Exception ex) {
            context.setError("Failed to add comment", ex);
            return;
        }
    }
}

