/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class AssignTaskActionListener
implements JbpmActionListener {
    private final ValueExpression taskInstanceExpression;
    private final ValueExpression actorIdExpression;
    private final ValueExpression overwriteSwimlaneExpression;

    public AssignTaskActionListener(ValueExpression taskInstanceExpression, ValueExpression actorIdExpression, ValueExpression overwriteSwimlaneExpression) {
        this.taskInstanceExpression = taskInstanceExpression;
        this.actorIdExpression = actorIdExpression;
        this.overwriteSwimlaneExpression = overwriteSwimlaneExpression;
    }

    public String getName() {
        return "assignTask";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object taskInstanceValue = this.taskInstanceExpression.getValue(elContext);
            if (taskInstanceValue == null) {
                context.setError("Error assigning task", "The task instance value is null");
                return;
            }
            if (!(taskInstanceValue instanceof TaskInstance)) {
                context.setError("Error assigning task", "Attempted to assigning something other than a task instance");
                return;
            }
            TaskInstance taskInstance = (TaskInstance)taskInstanceValue;
            if (this.actorIdExpression == null) {
                context.setError("Error assigning task", "Actor ID expression is null");
                return;
            }
            Object actorIdValue = this.actorIdExpression.getValue(elContext);
            if (actorIdValue == null) {
                context.setError("Error assigning task", "Actor ID expression resolved to null");
                return;
            }
            String actorId = actorIdValue.toString();
            if (this.overwriteSwimlaneExpression != null) {
                Object overwriteSwimlaneValue = this.overwriteSwimlaneExpression.getValue(elContext);
                if (overwriteSwimlaneValue == null) {
                    context.setError("Error assigning task", "Overwrite swimlane expression resolved to null");
                    return;
                }
                Boolean overwriteSwimlane = overwriteSwimlaneValue instanceof Boolean ? (Boolean)overwriteSwimlaneValue : Boolean.valueOf(overwriteSwimlaneValue.toString());
                taskInstance.setActorId(actorId, overwriteSwimlane.booleanValue());
            } else {
                taskInstance.setActorId(actorId);
            }
            context.addSuccessMessage("Task assigned");
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error assigning task", ex);
            return;
        }
    }
}

