/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class GetVariableActionListener
implements JbpmActionListener {
    private final ValueExpression nameExpression;
    private final ValueExpression targetExpression;
    private final ValueExpression entityExpression;

    public GetVariableActionListener(ValueExpression nameExpression, ValueExpression targetExpression, ValueExpression entityExpression) {
        this.nameExpression = nameExpression;
        this.targetExpression = targetExpression;
        this.entityExpression = entityExpression;
    }

    public String getName() {
        return "getVariable";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            Object value;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object nameValue = this.nameExpression.getValue(elContext);
            if (nameValue == null) {
                context.setError("Error getting variable", "The value of the 'name' attribute is null");
                return;
            }
            String name = nameValue.toString();
            Object entity = this.entityExpression.getValue(elContext);
            if (entity instanceof TaskInstance) {
                TaskInstance task = (TaskInstance)entity;
                value = task.getVariable(name);
            } else if (entity instanceof Token) {
                Token token = (Token)entity;
                ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
                value = contextInstance.getVariable(name, token);
            } else if (entity instanceof ProcessInstance) {
                ProcessInstance processInstance = (ProcessInstance)entity;
                ContextInstance contextInstance = processInstance.getContextInstance();
                value = contextInstance.getVariable(name);
            } else {
                context.setError("Error getting variable", "The value given for the 'entity' attribute is not a task, token, or process instance");
                return;
            }
            this.targetExpression.setValue(elContext, value);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error getting variable", ex);
            return;
        }
    }
}

