/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.job.Job;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class LoadJobActionListener
implements JbpmActionListener {
    private final ValueExpression idExpression;
    private final ValueExpression targetExpression;

    public LoadJobActionListener(ValueExpression idExpression, ValueExpression targetExpression) {
        this.idExpression = idExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "loadJob";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object idValue = this.idExpression.getValue(elContext);
            if (idValue == null) {
                context.setError("Error loading job instance", "The ID value is null");
                return;
            }
            long id = idValue instanceof Long ? ((Long)idValue).longValue() : Long.valueOf(idValue.toString()).longValue();
            Job job = context.getJbpmContext().getJobSession().getJob(id);
            if (job == null) {
                context.setError("Error loading job instance", "No job instance was found with an ID of " + id);
                return;
            }
            this.targetExpression.setValue(elContext, (Object)job);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading job", ex);
            return;
        }
    }
}

