/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.Group;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class CreateGroupActionListener
implements JbpmActionListener {
    private final ValueExpression groupNameExpression;
    private final ValueExpression parentGroupExpression;
    private final ValueExpression typeExpression;
    private final ValueExpression targetExpression;

    public CreateGroupActionListener(ValueExpression groupNameExpression, ValueExpression parentGroupExpression, ValueExpression typeExpression, ValueExpression targetExpression) {
        this.groupNameExpression = groupNameExpression;
        this.parentGroupExpression = parentGroupExpression;
        this.typeExpression = typeExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "createGroup";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            IdentitySession identitySession = new IdentitySession(context.getJbpmContext().getSession());
            if (this.groupNameExpression == null) {
                context.setError("Error creating group", "The group name expression is missing");
                return;
            }
            Object groupNameValue = this.groupNameExpression.getValue(elContext);
            if (groupNameValue == null) {
                context.setError("Error creating group", "The group name value is null");
                return;
            }
            Group group = new Group(groupNameValue.toString());
            if (this.parentGroupExpression != null) {
                Object parentGroupValue = this.parentGroupExpression.getValue(elContext);
                if (parentGroupValue instanceof Group) {
                    group.setParent((Group)parentGroupValue);
                } else if (parentGroupValue != null) {
                    context.setError("Error creating group", "The parent group is not a Group instance");
                    return;
                }
            }
            if (this.typeExpression != null) {
                Object typeValue = this.typeExpression.getValue(elContext);
                if (typeValue == null) {
                    context.setError("Error creating group", "The type value is null");
                    return;
                }
                group.setType(typeValue.toString());
            }
            identitySession.saveGroup(group);
            if (this.targetExpression != null) {
                this.targetExpression.setValue(elContext, (Object)group);
            }
            context.selectOutcome("success");
            context.addSuccessMessage("Group created successfully");
        }
        catch (Exception ex) {
            context.setError("Error loading group", ex);
            return;
        }
    }
}

