/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private JbpmConfiguration jbpmConfiguration;
    private static final Log log = LogFactory.getLog((Class)(class$org$jbpm$web$ProcessUploadServlet == null ? (class$org$jbpm$web$ProcessUploadServlet = ProcessUploadServlet.class$((String)"org.jbpm.web.ProcessUploadServlet")) : class$org$jbpm$web$ProcessUploadServlet));
    static /* synthetic */ Class class$org$jbpm$web$ProcessUploadServlet;

    public void init() throws ServletException {
        String jbpmCfgResource = this.getServletContext().getInitParameter("jbpm.configuration.resource");
        this.jbpmConfiguration = JbpmConfiguration.getInstance((String)jbpmCfgResource);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"handling status request");
        }
        PrintWriter out = response.getWriter();
        this.writeHeader(out);
        out.println("<h3>Deploy a process</h3>");
        out.println("<form name='deploy-form' method='post' enctype='multipart/form-data'>");
        out.println("  <p>Process Archive: <input name='process-archive' type='file'/>");
        out.println("  <p><input name='deploy-button' type='submit' value='Deploy'/>");
        out.println("</form>");
        this.writeTrailer(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileItem processItem;
        if (log.isTraceEnabled()) {
            log.trace((Object)"handling upload request");
        }
        if ((processItem = this.parseRequest(request, response)) == null) {
            return;
        }
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            ProcessDefinition processDefinition = this.parseProcessArchive(processItem);
            this.deployProcessDefinition(processDefinition, response);
        }
        finally {
            jbpmContext.close();
        }
    }

    private void writeHeader(PrintWriter out) throws MalformedURLException {
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Process Deployment</title>");
        URL css = this.getServletContext().getResource("/ua/jbpm.css");
        if (css != null) {
            out.print("<link rel='stylesheet' type='text/css' href='");
            out.print(css.toString());
            out.println("'/>");
        }
        out.println("</head>");
        out.println("<body>");
    }

    private void writeTrailer(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    private FileItem parseRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            response.sendError(400, "Not a multipart request");
            return null;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            if (items.isEmpty()) {
                response.sendError(400, "Request is empty");
                return null;
            }
            FileItem item = (FileItem)items.get(0);
            if (item.isFormField()) {
                response.sendError(400, "Field '" + item.getFieldName() + "' is not an input file");
                return null;
            }
            return item;
        }
        catch (FileUploadException e) {
            log.error((Object)"failed to parse request", (Throwable)e);
            response.sendError(400, "Failed to parse request");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessDefinition parseProcessArchive(FileItem fileItem) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("parsing process archive " + fileItem.getName()));
        }
        ZipInputStream processStream = new ZipInputStream(fileItem.getInputStream());
        try {
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)processStream);
            if (log.isTraceEnabled()) {
                log.trace((Object)("parsed process definition " + processDefinition.getName()));
            }
            ProcessDefinition processDefinition2 = processDefinition;
            return processDefinition2;
        }
        finally {
            processStream.close();
        }
    }

    private void deployProcessDefinition(ProcessDefinition processDefinition, HttpServletResponse response) throws IOException {
        String processName = processDefinition.getName();
        JbpmContext jbpmContext = this.jbpmConfiguration.getCurrentJbpmContext();
        try {
            jbpmContext.deployProcessDefinition(processDefinition);
            if (log.isTraceEnabled()) {
                log.trace((Object)("deployed process definition " + processName));
            }
            PrintWriter out = response.getWriter();
            this.writeHeader(out);
            out.println("<h3>Deployment report</h3>");
            out.print("<p>Deployed process ");
            out.print(processName);
            out.println(" successfully</p>");
            this.writeTrailer(out);
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.error((Object)("failed to deploy process definition " + processName), (Throwable)e);
            response.sendError(500, "Failed to deploy process");
        }
    }
}

