/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.migration;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

abstract class ErrorCollector<T extends Exception> {
    private final List<T> warningList = new ArrayList<T>();
    private final List<T> errorList = new ArrayList<T>();
    private final List<T> fatalList = new ArrayList<T>();

    ErrorCollector() {
    }

    public void warning(T ex) {
        this.warningList.add(ex);
    }

    public void error(T ex) {
        this.errorList.add(ex);
    }

    public void fatalError(T ex) {
        this.fatalList.add(ex);
    }

    public boolean didErrorOccur() {
        return !this.warningList.isEmpty() || !this.errorList.isEmpty() || !this.fatalList.isEmpty();
    }

    public List<T> getWarningList() {
        return this.warningList;
    }

    public List<T> getErrorList() {
        return this.errorList;
    }

    public List<T> getFatalList() {
        return this.fatalList;
    }

    public void logErrors(Logger logger) {
        for (Exception ex : this.warningList) {
            logger.warn((Object)"==>", (Throwable)ex);
        }
        for (Exception ex : this.errorList) {
            logger.error((Object)"==>", (Throwable)ex);
        }
        for (Exception ex : this.fatalList) {
            logger.fatal((Object)"==>", (Throwable)ex);
        }
    }
}

