/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.migration;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.migration.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class Validator {
    private static final String JPDL_3_2_SCHEMA = "jpdl-3.2.xsd";
    private static final String BPMN_2_0_SCHEMA = "BPMN20.xsd";
    private static final Logger LOGGER = Logger.getLogger(Validator.class);

    private Validator() {
    }

    static Document loadDefinition(File def) {
        Document document = XmlUtils.parseFile(def);
        if (document == null) {
            return null;
        }
        Node xmlnsNode = document.getFirstChild().getAttributes().getNamedItem("xmlns");
        if (xmlnsNode != null && StringUtils.isNotBlank((CharSequence)xmlnsNode.getNodeValue()) && xmlnsNode.getNodeValue().contains("jpdl")) {
            String version = xmlnsNode.getNodeValue().substring(xmlnsNode.getNodeValue().length() - 3);
            LOGGER.info((Object)("jPDL version == " + version));
        }
        return document;
    }

    static boolean validateDefinition(Document def, ProcessLanguage language) {
        return XmlUtils.validate(new DOMSource(def), language.getSchemaSources());
    }

    static boolean validateDefinition(String def, ProcessLanguage language) {
        return XmlUtils.validate(new StreamSource(new StringReader(def)), language.getSchemaSources());
    }

    static enum ProcessLanguage {
        JPDL("jpdl-3.2.xsd"),
        BPMN("BPMN20.xsd");

        private final List<String> schemas = new ArrayList<String>();

        private ProcessLanguage(String ... schemas) {
            for (String schema : schemas) {
                this.schemas.add(schema);
            }
        }

        Source[] getSchemaSources() {
            Source[] sources = new Source[this.schemas.size()];
            for (String schema : this.schemas) {
                sources[this.schemas.indexOf((Object)schema)] = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(schema));
            }
            return sources;
        }
    }
}

