/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.task.views;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jbpm.task.AccessType;
import org.jbpm.task.I18NText;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.service.ContentData;

public class NewTaskDialog
extends Dialog {
    private Task task;
    private ContentData content;
    private Text nameText;
    private Text actorText;
    private Text subjectText;
    private Text commentText;
    private Text priorityText;
    private Button skippableButton;
    private Text contentText;
    private Text localeText;

    public NewTaskDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create New Task");
    }

    protected Point getInitialSize() {
        return new Point(450, 350);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Name: ");
        this.nameText = new Text(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Potential owner(s): ");
        this.actorText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.actorText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Subject: ");
        this.subjectText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.subjectText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Comment: ");
        this.commentText = new Text(composite, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.commentText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Priority: ");
        this.priorityText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.priorityText.setLayoutData((Object)gridData);
        this.skippableButton = new Button(composite, 16416);
        this.skippableButton.setText("Skippable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.skippableButton.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Content: ");
        this.contentText = new Text(composite, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.contentText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Locale: ");
        this.localeText = new Text(composite, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.localeText.setLayoutData((Object)gridData);
        this.localeText.setText("en-UK");
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.createTask();
        }
        super.buttonPressed(buttonId);
    }

    private void createTask() {
        this.task = new Task();
        String locale = this.localeText.getText();
        if (locale == null || locale.length() == 0) {
            locale = "en-UK";
        }
        String taskName = this.nameText.getText();
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        names.add(new I18NText(locale, taskName));
        this.task.setNames(names);
        String subject = this.subjectText.getText();
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        subjects.add(new I18NText(locale, subject));
        this.task.setSubjects(subjects);
        String comment = this.commentText.getText();
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        descriptions.add(new I18NText(locale, comment));
        this.task.setDescriptions(descriptions);
        String priority = this.priorityText.getText();
        this.priorityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String priority = NewTaskDialog.this.priorityText.getText();
                boolean enabled = false;
                if (priority.length() == 0) {
                    enabled = true;
                } else {
                    try {
                        new Integer(priority);
                        enabled = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                NewTaskDialog.this.getButton(0).setEnabled(enabled);
            }
        });
        try {
            this.task.setPriority(new Integer(priority).intValue());
        }
        catch (NumberFormatException numberFormatException) {}
        TaskData taskData = new TaskData();
        taskData.setSkipable(this.skippableButton.getSelection());
        this.task.setTaskData(taskData);
        String actors = this.actorText.getText();
        PeopleAssignments assignments = new PeopleAssignments();
        String[] actorIds = actors.trim().split(",");
        ArrayList<User> potentialOwners = new ArrayList<User>();
        String[] stringArray = actorIds;
        int n = actorIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            User user = new User();
            user.setId(id.trim());
            potentialOwners.add(user);
            ++n2;
        }
        assignments.setPotentialOwners(potentialOwners);
        ArrayList<User> businessAdministrators = new ArrayList<User>();
        businessAdministrators.add(new User("Administrator"));
        assignments.setBusinessAdministrators(businessAdministrators);
        this.task.setPeopleAssignments(assignments);
        ContentData content = null;
        String contentString = this.contentText.getText();
        content = new ContentData();
        content.setContent(contentString.getBytes());
        content.setAccessType(AccessType.Inline);
    }

    public Task getTask() {
        return this.task;
    }

    public ContentData getContent() {
        return this.content;
    }
}

