/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.jbpm.eclipse.util.JBPMRuntimeManager;

public class JBPMClasspathContainer
implements IClasspathContainer {
    IClasspathEntry[] jbpmLibraryEntries;
    IPath path;
    IJavaProject javaProject = null;

    public JBPMClasspathContainer(IJavaProject project, IPath path) {
        this.javaProject = project;
        this.path = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.jbpmLibraryEntries == null) {
            this.jbpmLibraryEntries = this.createJBPMLibraryEntries(this.javaProject);
        }
        return this.jbpmLibraryEntries;
    }

    public String getDescription() {
        return "jBPM Library";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private IClasspathEntry[] createJBPMLibraryEntries(IJavaProject project) {
        String[] jarNames = this.getJarNames(project);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        if (jarNames != null) {
            int i = 0;
            while (i < jarNames.length) {
                Path path = new Path(jarNames[i]);
                if (jarNames[i].contains("knowledge-api") || jarNames[i].contains("kie-api") || jarNames[i].contains("jbpm-test")) {
                    list.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null));
                } else {
                    IAccessRule[] accessRules = new IAccessRule[]{new ClasspathAccessRule((IPath)new Path("**"), 2)};
                    list.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (IAccessRule[])accessRules, (IClasspathAttribute[])ClasspathEntry.NO_EXTRA_ATTRIBUTES, (boolean)false));
                }
                ++i;
            }
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    private String[] getJarNames(IJavaProject project) {
        return JBPMRuntimeManager.getJBPMRuntimeJars(project.getProject());
    }
}

