/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.action;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.processes.RuleFlowMigrator;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;

public class GenerateBPMN2JUnitTests
implements IObjectActionDelegate {
    private IFile file;
    private IWorkbenchPart targetPart;
    private boolean firstHumanTask = true;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.file != null && this.file.exists()) {
            try {
                this.generateJUnitTests();
            }
            catch (Throwable t) {
                JBPMEclipsePlugin.log(t);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1 && (element = structured.getFirstElement()) instanceof IFile) {
            this.file = (IFile)element;
        }
    }

    public void generateJUnitTests() {
        this.firstHumanTask = true;
        try {
            final IJavaProject javaProject = JavaCore.create((IProject)this.file.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return;
            }
            InputStreamReader isr = new InputStreamReader(((File)this.file).getContents());
            PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
            SemanticModules modules = configuration.getSemanticModules();
            modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            modules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(modules, Thread.currentThread().getContextClassLoader());
            String xml = RuleFlowMigrator.convertReaderToString((Reader)isr);
            StringReader reader = new StringReader(xml);
            List processes = xmlReader.read((Reader)reader);
            if (processes != null && processes.size() == 1) {
                final RuleFlowProcess process = (RuleFlowProcess)processes.get(0);
                String packageName = process.getPackageName();
                if (packageName == null || packageName.trim().length() == 0 || "org.drools.bpmn2".equals(packageName)) {
                    packageName = "org.jbpm";
                }
                final String pName = packageName;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        try {
                            IFolder folder = GenerateBPMN2JUnitTests.this.file.getProject().getFolder("src/main/java");
                            IPackageFragmentRoot packageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)folder);
                            IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment(pName, true, monitor);
                            String processName = process.getName();
                            processName = processName.replaceAll("\\s", "_");
                            if (processName == null || processName.trim().length() == 0) {
                                processName = "Process";
                            }
                            String fileName = String.valueOf(processName) + "JUnitTest";
                            String output = "package " + pName + ";\n" + "\n" + "import java.util.ArrayList;\n" + "import java.util.HashMap;\n" + "import java.util.List;\n" + "import java.util.Map;\n" + "\n" + "import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;\n" + "import org.jbpm.test.JbpmJUnitTestCase;\n" + "\n" + "import org.junit.Test;\n" + "\n" + "import org.kie.api.runtime.KieSession;\n" + "import org.kie.api.runtime.process.ProcessInstance;\n" + "import org.kie.api.task.TaskService;\n" + "import org.kie.api.task.model.TaskSummary;\n" + "\n" + "public class " + fileName + " extends JbpmJUnitTestCase {\n" + "\n";
                            boolean containsHumanTasks = GenerateBPMN2JUnitTests.containsHumanTasks((NodeContainer)process);
                            if (containsHumanTasks) {
                                output = String.valueOf(output) + "    public " + fileName + "() {\n" + "        super(true);\n" + "    }\n" + "\n";
                            }
                            HashMap<String, String> cases = new HashMap<String, String>();
                            HashMap ongoingCases = new HashMap();
                            boolean done = GenerateBPMN2JUnitTests.this.processNodes("", (Node)process.getStart(null), "", cases, ongoingCases);
                            if (!done) {
                                if (ongoingCases.size() == 1) {
                                    cases.put("Implicit", (String)ongoingCases.values().iterator().next());
                                } else {
                                    throw new IllegalArgumentException("Could not create implicit case: " + ongoingCases.size());
                                }
                            }
                            for (Map.Entry entry : cases.entrySet()) {
                                List variables;
                                output = String.valueOf(output) + "\t@Test\n    public void test" + (String)entry.getKey() + "() {\n" + "        KieSession ksession = createKnowledgeSession(\"" + GenerateBPMN2JUnitTests.this.file.getName() + "\");\n";
                                HashSet serviceTasks = new HashSet();
                                GenerateBPMN2JUnitTests.this.containsServiceTasks(serviceTasks, (NodeContainer)process);
                                for (String service : serviceTasks) {
                                    output = String.valueOf(output) + "        ksession.getWorkItemManager().registerWorkItemHandler(\"" + service + "\", new SystemOutWorkItemHandler());\n";
                                }
                                if (containsHumanTasks) {
                                    output = String.valueOf(output) + "        TaskService taskService = getTaskService();\n";
                                }
                                if ((variables = process.getVariableScope().getVariables()) != null && variables.size() > 0) {
                                    output = String.valueOf(output) + "        Map<String, Object> params = new HashMap<String, Object>();\n        // initialize variables here if necessary\n";
                                    for (Variable v : variables) {
                                        output = String.valueOf(output) + "        // params.put(\"" + v.getName() + "\", value); // type " + v.getType().getStringType() + "\n";
                                    }
                                    output = String.valueOf(output) + "        ProcessInstance processInstance = ksession.startProcess(\"" + process.getId() + "\", params);\n";
                                } else {
                                    output = String.valueOf(output) + "        ProcessInstance processInstance = ksession.startProcess(\"" + process.getId() + "\");\n";
                                }
                                output = String.valueOf(output) + (String)entry.getValue() + "        // do your checks here\n" + "        // for example, assertProcessInstanceCompleted(processInstance.getId(), ksession);\n" + "    }\n" + "\n";
                            }
                            output = String.valueOf(output) + "}";
                            packageFragment.createCompilationUnit(String.valueOf(fileName) + ".java", output, true, monitor);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageDialog.openError(null, (String)"Error", (String)e.getMessage());
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.targetPart.getSite().getShell()).run(false, true, (IRunnableWithProgress)op);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean processNodes(String name, Node currentNode, String testCode, Map<String, String> cases, Map<String, String> ongoingCases) {
        if (currentNode instanceof Split) {
            Split split = (Split)currentNode;
            switch (split.getType()) {
                case 1: {
                    boolean done = false;
                    String startTestCode = testCode;
                    int counter = 1;
                    for (Connection c : split.getDefaultOutgoingConnections()) {
                        if (!this.processNodes(String.valueOf(name) + counter++, c.getTo(), startTestCode, cases, ongoingCases)) continue;
                        done = true;
                    }
                    if (!done) {
                        String implicitCompleteTestCode = startTestCode;
                        for (String ongoingCase : ongoingCases.values()) {
                            implicitCompleteTestCode = String.valueOf(implicitCompleteTestCode) + ongoingCase.substring(startTestCode.length(), ongoingCase.length());
                        }
                        ongoingCases.clear();
                        ongoingCases.put(name, implicitCompleteTestCode);
                    }
                    return done;
                }
                case 2: 
                case 3: {
                    int i = 1;
                    boolean done = true;
                    for (Connection c : split.getDefaultOutgoingConnections()) {
                        String newTestCode = String.valueOf(testCode) + "        // please make sure that the following constraint is selected to node " + c.getTo().getName() + ":\n" + "        // " + split.getConstraint(c).getConstraint() + "\n";
                        if (this.processNodes(String.valueOf(name) + "Constraint" + i++, c.getTo(), newTestCode, cases, ongoingCases)) continue;
                        done = false;
                    }
                    return done;
                }
            }
            throw new IllegalArgumentException("Unknown split type " + split.getType());
        }
        if (currentNode instanceof EndNode) {
            EndNode endNode = (EndNode)currentNode;
            if (endNode.isTerminate()) {
                cases.put(name, testCode);
                return true;
            }
            ongoingCases.put(name, testCode);
            return false;
        }
        if (currentNode instanceof HumanTaskNode) {
            String groupId;
            HumanTaskNode taskNode = (HumanTaskNode)currentNode;
            String actorId = (String)taskNode.getWork().getParameter("ActorId");
            if (actorId == null) {
                actorId = "";
            }
            if ((groupId = (String)taskNode.getWork().getParameter("GroupId")) == null) {
                groupId = "";
            }
            String[] actorIds = new String[]{};
            if (actorId.trim().length() > 0) {
                actorIds = actorId.split(",");
            }
            String[] groupIds = new String[]{};
            if (groupId.trim().length() > 0) {
                groupIds = groupId.split(",");
            }
            actorId = actorIds.length > 0 ? actorIds[0] : "";
            testCode = this.firstHumanTask ? String.valueOf(testCode) + "        // execute task\n        String actorId = \"" + actorId + "\";\n" + "        List<TaskSummary> list = taskService.getTasksAssignedAsPotentialOwner(actorId, \"en-UK\");\n" + "        TaskSummary task = list.get(0);\n" : String.valueOf(testCode) + "        // execute task\n        actorId = \"" + actorId + "\";\n" + "        list = taskService.getTasksAssignedAsPotentialOwner(actorId, \"en-UK\");\n" + "        task = list.get(0);\n";
            if (actorIds.length > 1 || groupIds.length > 0) {
                testCode = String.valueOf(testCode) + "        taskService.claim(task.getId(), actorId);\n";
            }
            if (this.firstHumanTask) {
                testCode = String.valueOf(testCode) + "        taskService.start(task.getId(), actorId);\n        Map<String, Object> results = new HashMap<String, Object>();\n        // add results here\n";
                this.firstHumanTask = false;
            } else {
                testCode = String.valueOf(testCode) + "        taskService.start(task.getId(), actorId);\n        results = new HashMap<String, Object>();\n        // add results here\n";
            }
            for (Map.Entry entry : taskNode.getOutMappings().entrySet()) {
                String type = null;
                VariableScope variableScope = (VariableScope)taskNode.resolveContext("VariableScope", entry.getValue());
                if (variableScope != null) {
                    type = variableScope.findVariable((String)entry.getValue()).getType().getStringType();
                }
                testCode = String.valueOf(testCode) + "        // results.put(\"" + (String)entry.getKey() + "\", value);" + (type == null ? "" : " // type " + type) + "\n";
            }
            testCode = String.valueOf(testCode) + "        taskService.complete(task.getId(), actorId, results);\n\n";
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        if (currentNode instanceof WorkItemNode) {
            WorkItemNode taskNode = (WorkItemNode)currentNode;
            testCode = String.valueOf(testCode) + "        // if necessary, complete request for service task \"" + taskNode.getWork().getName() + "\"\n";
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        if (currentNode instanceof EventNode) {
            EventNode eventNode = (EventNode)currentNode;
            testCode = String.valueOf(testCode) + "        ksession.signalEvent(\"" + eventNode.getType() + "\", null, processInstance.getId());\n";
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        if (currentNode instanceof TimerNode) {
            testCode = String.valueOf(testCode) + "        // wait for timer to expire\n        // for example, try { Thread.sleep(delay); } catch (Exception e) { /* Do nothing */ }";
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        if (currentNode instanceof ForEachNode) {
            CompositeContextNode compositeNode = ((ForEachNode)currentNode).getCompositeNode();
            testCode = String.valueOf(testCode) + "        // --> triggering each element in the collection:\n";
            boolean done = true;
            Node[] nodeArray = compositeNode.getNodes();
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StartNode startNode;
                Node node = nodeArray[n2];
                if (node instanceof StartNode && ((startNode = (StartNode)node).getTriggers() == null || startNode.getTriggers().isEmpty())) {
                    done = this.processNodes(name, startNode.getTo().getTo(), testCode, cases, ongoingCases);
                    break;
                }
                ++n2;
            }
            if (done) {
                for (Map.Entry<String, String> c : cases.entrySet()) {
                    if (!c.getKey().startsWith(name)) continue;
                    cases.put(c.getKey(), String.valueOf(c.getValue()) + "        // <-- do this for one element in the collection:\n");
                }
                return true;
            }
            if (ongoingCases.size() == 1) {
                testCode = String.valueOf(ongoingCases.values().iterator().next()) + "        // <-- do this for each element in the collection:\n";
                return this.processNodes(String.valueOf(name) + "Implicit", ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
            }
            throw new IllegalArgumentException("Could not create implicit case: " + ongoingCases.size());
        }
        if (currentNode instanceof CompositeNode) {
            CompositeNode compositeNode = (CompositeNode)currentNode;
            boolean done = true;
            Node[] nodeArray = compositeNode.getNodes();
            int n = nodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                StartNode startNode;
                Node node = nodeArray[n3];
                if (node instanceof StartNode && ((startNode = (StartNode)node).getTriggers() == null || startNode.getTriggers().isEmpty())) {
                    done = this.processNodes(name, startNode.getTo().getTo(), testCode, cases, ongoingCases);
                    break;
                }
                ++n3;
            }
            if (done) {
                return true;
            }
            if (ongoingCases.size() == 1) {
                return this.processNodes(String.valueOf(name) + "Implicit", ((NodeImpl)currentNode).getTo().getTo(), ongoingCases.values().iterator().next(), cases, ongoingCases);
            }
            throw new IllegalArgumentException("Could not create implicit case: " + ongoingCases.size());
        }
        if (currentNode instanceof RuleSetNode) {
            testCode = String.valueOf(testCode) + "        ksession.fireAllRules();\n";
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        if (currentNode instanceof SubProcessNode) {
            SubProcessNode subProcessNode = (SubProcessNode)currentNode;
            if (subProcessNode.isWaitForCompletion()) {
                testCode = String.valueOf(testCode) + "        // invoking subprocess " + subProcessNode.getProcessId() + ", if necessary make sure it is completed\n";
            }
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        if (currentNode instanceof FaultNode) {
            FaultNode faultNode = (FaultNode)currentNode;
            testCode = String.valueOf(testCode) + "        // handle fault " + faultNode.getFaultName() + " if necessary\n";
            return true;
        }
        if (currentNode instanceof Join) {
            Join join = (Join)currentNode;
            switch (join.getType()) {
                case 1: {
                    throw new IllegalArgumentException("Generation of tests that include a convering parallel gateway is not yet supported");
                }
                case 2: {
                    return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
                }
            }
            throw new IllegalArgumentException("Unknown join type " + join.getType());
        }
        if (currentNode instanceof NodeImpl) {
            return this.processNodes(name, ((NodeImpl)currentNode).getTo().getTo(), testCode, cases, ongoingCases);
        }
        throw new IllegalArgumentException("Unknown node " + currentNode);
    }

    private static boolean containsHumanTasks(NodeContainer c) {
        Node[] nodeArray = c.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof HumanTaskNode) {
                return true;
            }
            if (node instanceof NodeContainer && GenerateBPMN2JUnitTests.containsHumanTasks((NodeContainer)node)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void containsServiceTasks(Set<String> result, NodeContainer c) {
        Node[] nodeArray = c.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof WorkItemNode && !(node instanceof HumanTaskNode)) {
                result.add(((WorkItemNode)node).getWork().getName());
            }
            if (node instanceof NodeContainer) {
                this.containsServiceTasks(result, (NodeContainer)node);
            }
            ++n2;
        }
    }
}

