/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.wizard.project;

import java.util.HashMap;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.jbpm.eclipse.util.JBPMRuntimeManager;

public class NewJBPMProjectRuntimeWizardPage
extends WizardPage {
    public static final String JBPM5 = "jBPM 5";
    public static final String JBPM6 = "jBPM 6";
    private boolean isDefaultRuntime = true;
    private String selectedRuntime;
    private String generationType = "jBPM 6";
    private Button projectSpecificRuntime;
    private Combo jBPMRuntimeCombo;
    private Combo jbpmGenerateCombo;

    public NewJBPMProjectRuntimeWizardPage() {
        super("extendedNewProjectRuntimePage");
        this.setTitle("jBPM Runtime");
        this.setDescription("Select a jBPM Runtime");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        JBPMRuntime defaultRuntime = JBPMRuntimeManager.getDefaultJBPMRuntime();
        this.projectSpecificRuntime = this.createCheckBox(composite, "Use default jBPM Runtime (currently " + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
        this.projectSpecificRuntime.setSelection(true);
        this.projectSpecificRuntime.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.isDefaultRuntime = ((Button)e.widget).getSelection();
                NewJBPMProjectRuntimeWizardPage.this.jBPMRuntimeCombo.setEnabled(!NewJBPMProjectRuntimeWizardPage.this.isDefaultRuntime);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.projectSpecificRuntime.setLayoutData((Object)gridData);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("jBPM Runtime: ");
        this.jBPMRuntimeCombo = new Combo(composite, 8);
        this.jBPMRuntimeCombo.setEnabled(false);
        this.jBPMRuntimeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.selectedRuntime = NewJBPMProjectRuntimeWizardPage.this.jBPMRuntimeCombo.getText();
            }

            public void widgetSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.selectedRuntime = NewJBPMProjectRuntimeWizardPage.this.jBPMRuntimeCombo.getText();
            }
        });
        JBPMRuntime[] runtimes = JBPMRuntimeManager.getJBPMRuntimes();
        if (runtimes.length == 0) {
            this.setErrorMessage("No jBPM Runtimes have been defined, configure workspace settings first");
        } else {
            this.setErrorMessage(null);
            int i = 0;
            while (i < runtimes.length) {
                this.jBPMRuntimeCombo.add(runtimes[i].getName());
                ++i;
            }
            this.jBPMRuntimeCombo.select(0);
            this.selectedRuntime = this.jBPMRuntimeCombo.getText();
        }
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.jBPMRuntimeCombo.setLayoutData((Object)gridData);
        Link changeWorkspaceSettingsLink = this.createLink(composite, "Configure Workspace Settings...");
        changeWorkspaceSettingsLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Composite subPanel = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        subPanel.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        subPanel.setLayoutData((Object)gridData);
        Label generateLabel = new Label(subPanel, 0);
        generateLabel.setText("Generate code compatible with: ");
        this.jbpmGenerateCombo = new Combo(subPanel, 8);
        this.jbpmGenerateCombo.add(JBPM5);
        this.jbpmGenerateCombo.add("jBPM 6 or above");
        this.jbpmGenerateCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.generationType = NewJBPMProjectRuntimeWizardPage.this.jbpmGenerateCombo.getText();
            }

            public void widgetSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.generationType = NewJBPMProjectRuntimeWizardPage.this.jbpmGenerateCombo.getText();
            }
        });
        this.jbpmGenerateCombo.select(1);
        this.generationType = JBPM6;
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.jbpmGenerateCombo.setLayoutData((Object)gridData);
        this.setMessage(null);
        this.setPageComplete(runtimes.length > 0);
        this.setControl((Control)composite);
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.openLink();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewJBPMProjectRuntimeWizardPage.this.openLink();
            }
        });
        return link;
    }

    private void openLink() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.jbpm.eclipse.preferences.JBPMRuntimesPreferencePage", (String[])new String[]{"org.jbpm.eclipse.preferences.JBPMProjectPreferencePage"}, new HashMap()).open();
        this.jBPMRuntimeCombo.removeAll();
        JBPMRuntime[] runtimes = JBPMRuntimeManager.getJBPMRuntimes();
        if (runtimes.length == 0) {
            this.setPageComplete(false);
            this.setErrorMessage("No jBPM Runtimes have been defined, please do this first");
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            int i = 0;
            while (i < runtimes.length) {
                this.jBPMRuntimeCombo.add(runtimes[i].getName());
                ++i;
            }
            this.jBPMRuntimeCombo.select(0);
            this.selectedRuntime = this.jBPMRuntimeCombo.getText();
        }
        JBPMRuntime defaultRuntime = JBPMRuntimeManager.getDefaultJBPMRuntime();
        this.projectSpecificRuntime.setText("Use default jBPM Runtime (currently " + (defaultRuntime == null ? "undefined)" : String.valueOf(defaultRuntime.getName()) + ")"));
    }

    public JBPMRuntime getJBPMRuntime() {
        if (this.isDefaultRuntime) {
            return null;
        }
        return JBPMRuntimeManager.getJBPMRuntime(this.selectedRuntime);
    }

    public String getGenerationType() {
        return this.generationType;
    }
}

