/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.balalaika;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.balalaika.BirtService;
import org.jboss.balalaika.IntegrationConfig;
import org.jboss.balalaika.JMXServerConfig;
import org.jboss.balalaika.RenderMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Path(value="report")
public class ReportFacade {
    private static final Log log = LogFactory.getLog(ReportFacade.class);
    private BirtService birtService;
    private boolean isInitialized;

    public void lazyInitialize(HttpServletRequest request) {
        if (!this.isInitialized) {
            JMXServerConfig jmxConfig = new JMXServerConfig();
            IntegrationConfig iConfig = new IntegrationConfig();
            File severDataDir = jmxConfig.getServerDataDir();
            String absServerDataDir = severDataDir.getAbsolutePath();
            String birtDataDir = absServerDataDir + "/birt";
            String defaultBirtHome = birtDataDir + "/ReportEngine";
            String birtOutputDir = birtDataDir + "/output";
            File birtOutput = new File(birtOutputDir);
            birtOutput.mkdirs();
            if (!new File(defaultBirtHome).exists()) {
                throw new IllegalStateException("The BIRT report engine doesn't seem to be installed:" + defaultBirtHome);
            }
            iConfig.setBirtHome(defaultBirtHome);
            iConfig.setOutputDir(birtOutputDir);
            iConfig.setReportDir(birtDataDir);
            StringBuffer sb = new StringBuffer();
            sb.append("http://");
            sb.append(request.getServerName()).append(":");
            sb.append(request.getServerPort());
            sb.append(request.getContextPath());
            sb.append(request.getServletPath());
            sb.append("/report/view/image");
            iConfig.setImageBaseUrl(sb.toString());
            log.info((Object)("BIRT home: " + iConfig.getBirtHome()));
            log.info((Object)("Output dir: " + iConfig.getOutputDir()));
            log.info((Object)("Report dir: " + iConfig.getReportDir()));
            this.birtService = new BirtService(iConfig);
            this.birtService.create();
            this.isInitialized = true;
        }
    }

    @GET
    @Path(value="view/{fileName}")
    @Produces(value={"text/html"})
    public Response viewReportHtml(@PathParam(value="fileName") String fileName, @Context HttpServletRequest request) {
        this.lazyInitialize(request);
        Map queryParams = ReportFacade.convertRequestParametersToMap((HttpServletRequest)request);
        RenderMetaData renderMeta = new RenderMetaData();
        renderMeta.setReportName(fileName);
        renderMeta.setFormat(RenderMetaData.Format.HTML);
        renderMeta.setClassloader(Thread.currentThread().getContextClassLoader());
        renderMeta.getParameters().putAll(queryParams);
        String outputFileName = this.birtService.render(renderMeta);
        String absoluteFile = this.birtService.getIConfig().getOutputDir() + outputFileName;
        log.info((Object)("Render " + absoluteFile));
        File reportFile = new File(absoluteFile);
        return Response.ok((Object)reportFile).type("text/html").build();
    }

    @GET
    @Path(value="view/image/{fileName}")
    public Response getImage(@PathParam(value="fileName") String fileName, @Context HttpServletRequest request) {
        this.lazyInitialize(request);
        String imageDir = this.birtService.getIConfig().getImageDirectory();
        String absName = imageDir + fileName;
        File imageFile = new File(absName);
        if (!imageFile.exists()) {
            throw new IllegalArgumentException("Image " + absName + " doesn't exist");
        }
        return Response.ok((Object)imageFile).build();
    }

    public static Map<String, String> convertRequestParametersToMap(HttpServletRequest request) {
        Enumeration initParameters = request.getParameterNames();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        while (initParameters.hasMoreElements()) {
            String value;
            String param = (String)initParameters.nextElement();
            if (!(param != null & (value = request.getParameter(param)) != null)) continue;
            parameterMap.put(param, value);
        }
        return parameterMap;
    }
}

