/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.client;

//$Id: DialectHandler.java 1932 2008-08-19 15:23:12Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.io.Writer;
import java.net.URL;

import org.jboss.bpm.model.Process;

/**
 * The DialectHandler converts a supported dialect to the Process model.
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public interface DialectHandler
{
  String DEFAULT_NAMESPACE_URI = "urn:bpm.jboss:pdl-0.1";

  /**
   * Get the the supported namespace from this dialect. 
   */
  String getNamespaceURI();
  
  /**
   * Create a {@link Process} from a descriptor.
   * @param isInclude TODO
   */
  Process createProcess(String pXML, boolean isInclude);

  /**
   * Create a {@link Process} from a descriptor URL.
   * @param isInclude TODO
   */
  Process createProcess(URL pURL, boolean isInclude) throws IOException;

  /**
   * Marshall the process to the given writer
   */
  void marshallProcess(Process proc, Writer out) throws IOException;
}
