/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;



//$Id$


/**
 * An ArtifactInput, which is used in the definition of attributes for {@link InputSet}
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface ArtifactInput extends Artifact
{
  /**
   * This attribute identifies an Artifact that will be used as an input to an activity. The
   * identified Artifact will be part of an InputSet for an activity.
   */
  Artifact getArtifactRef();
  
  /**
   * The default value for this attribute is True. This means that the Input is required for
   * an activity to start. If set to False, then the activity MAY start within the input if it
   * is available, but MAY accept the input (more than once) after the activity has
   * started. An InputSet may have a some of ArtifactInputs that have this attribute set
   * to True and some that are set to False.
   */
  boolean isRequireForStart();

}
