/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;



//$Id$


/**
 * An ArtifactOutput, which is used in the definition of attributes for {@link OutputSet}
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface ArtifactOutput extends Artifact
{
  /**
   * This attribute identifies an Artifact that will be used as an output to an activity. The
   * identified Artifact will be part of an OutputSet for an activity.
   */
  Artifact getArtifactRef();
  
  /**
   * The default value for this attribute is True. This means that the Output will be
   * produced when an activity has been completed. If set to False, then the activity
   * MAY produce the output (more than once) before it has completed. An OutputSet
   * may have a some of ArtifactOutputs that have this attribute set to True and some that
   * are set to False.
   */
  boolean isProduceAtCompletion();

}
