/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;


//$Id$

/**
 * There are two ways of Connecting Objects in BPMN: a Flow, either sequence or message, and an Association. Sequence
 * Flow and Message Flow, to a certain extent, represent orthogonal aspects of the business processes depicted in a model,
 * although they both affect the performance of activities within a Process.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ConnectingObject
{
  /**
   * Name is an optional attribute that is text description of the Connecting Object.
   */
  String getName();

  /**
   * SourceRef is an attribute that identifies which Graphical Element the Connecting
   * Object is connected from. Note: there are restrictions as to what objects Sequence
   * Flow and Message Flow can connect. 
   */
  FlowObject getSourceRef();

  /**
   * TargetRef is an attribute that identifies which Graphical Element the Connecting
   * Object is connected to. Note: there are restrictions as to what objects Sequence
   * Flow and Message Flow can connect.
   */
  FlowObject getTargetRef();

  /**
   * Get the required target name
   */
  String getTargetName();
}