/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

//$Id$

import java.util.List;



/**
 * As the name implies, the End Event indicates where a Process will end. 
 * 
 * In terms of Sequence Flow, the End Event ends the flow of the Process, and thus, will not have any outgoing Sequence Flow. 
 * An End Event can have a specific Result that will appear as a marker within the center of the End Event shape. 
 * End Event Results are Message, Error, Compensation, Link, and Multiple.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface EndEvent extends Event, SingleInFlowSupport
{
  /** 
   * Result defines the type of result expected for an End Event. 
   * Of the set of EventDetailTypes only six can be applied to an 
   * End Event: Message, Error, Cancel, Compensation, Signal, and Terminate.
   * 
   * If there is no EventDetail defined, then this is considered a None End Event.
   * If there is more than one EventDetail defined, this is considered a Multiple EndEvent.
   */
  List<EventDetail> getResult();

}