/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;



//$Id$

/**
 * A Message Flow is a dashed line that is used to show the flow of messages between two entities that are prepared to
 * send and receive them. In BPMN, two separate Pools in the Diagram will represent the two entities.
 * 
 * Message Flow MUST connect two Pools, either to the Pools themselves or to Flow Objects within the Pools. They cannot
 * connect two objects within the same Pool.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface MessageFlow extends ConnectingObject
{
  /**
   * MessageRef is an optional attribute that identifies the Message that is being sent.
   */
  Message getMessageRef();
}