/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

//$Id: PropertySupport.java 1928 2008-08-19 10:45:22Z thomas.diesler@jboss.com $

import java.util.List;

/**
 * Property support
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface PropertySupport
{
  /**
   * Get a Property with a given name. 
   */
  Property getProperty(String name);

  /**
   * Get a Property value with a given name. 
   */
  Object getPropertyValue(String name);
  
  /**
   * Get a Property value with a given name. 
   */
  <T> T getPropertyValue(Class<T> clazz, String name);
  
  /**
   * Multiple Properties MAY entered for the Message.
   */
  List<Property> getProperties();

  /**
   * Get the list of property names
   */
  List<String> getPropertyNames();
}