/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.runtime;

//$Id: $

import java.util.Set;

import org.jboss.bpm.model.SequenceFlow;

/**
 * The {@link FlowHandler} invokes the TokenExecutor to move {@link Token}s
 * along the {@link SequenceFlow}s in the {@link Process}.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface TokenExecutor
{
  /**
   * Get the set of active tokens
   */
  Set<Token> getRunnableTokens();
  
  /**
   * True if there are active tokens
   */
  boolean hasRunnableTokens();
  
  /**
   * Create a {@link Token} with an initial flow
   */
  void create(Token token, SequenceFlow flow);
  
  /**
   * Start a {@link Token}
   */
  void start(Token token);
  
  /**
   * Stop a {@link Token}
   */
  void stop(Token token);
  
  /**
   * Destroy a {@link Token}
   */
  void destroy(Token token);
  
  /**
   * Suspend a {@link Token}
   */
  String suspend(Token token);
  
  /**
   * Activate a {@link Token}
   */
  Token activate(String tokenID);
  
  /**
   * Move a given {@link Token} along a given flow.
   */
  void move(Token token, SequenceFlow flow);
}
