/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.client;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.BPMException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.client.internal.EmbeddedBeansDeployer;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.util.KernelLocator;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;

public class ProcessEngine {
    private static final Log log = LogFactory.getLog(ProcessEngine.class);
    public static final String BEAN_NAME = "jBPMProcessEngine";
    public static final String JBPM_ENGINE_CONFIG = "jbpm-beans.xml";
    protected ProcessManager processManager;
    protected ExecutionManager executionManager;
    protected SignalManager signalManager;
    protected MessageManager messageManager;
    private boolean prepareForShutdown;

    protected ProcessEngine() {
    }

    public static ProcessEngine locateProcessEngine() {
        KernelRegistryEntry entry = null;
        Kernel kernel = KernelLocator.getKernel();
        if (kernel == null) {
            ProcessEngine.deployEngineConfiguration();
            kernel = KernelLocator.getKernel();
            entry = kernel.getRegistry().getEntry((Object)BEAN_NAME);
        } else {
            try {
                entry = kernel.getRegistry().getEntry((Object)BEAN_NAME);
            }
            catch (KernelRegistryEntryNotFoundException ex) {
                ProcessEngine.deployEngineConfiguration();
                entry = kernel.getRegistry().getEntry((Object)BEAN_NAME);
            }
        }
        ProcessEngine engine = (ProcessEngine)entry.getTarget();
        return engine;
    }

    private static void deployEngineConfiguration() {
        String config = JBPM_ENGINE_CONFIG;
        URL url = Thread.currentThread().getContextClassLoader().getResource(config);
        if (url == null) {
            throw new BPMException("Cannot find resource: " + config);
        }
        new EmbeddedBeansDeployer().deploy(url);
    }

    public void prepareForShutdown() {
        log.debug((Object)"prepareForShutdown");
        this.prepareForShutdown = true;
    }

    public boolean isPrepareForShutdown() {
        return this.prepareForShutdown;
    }

    public void cancelShutdown() {
        log.debug((Object)"cancelShutdown");
        this.prepareForShutdown = false;
    }

    public ProcessManager getProcessManager() {
        if (this.processManager == null) {
            throw new IllegalStateException("ProcessManager not available through kernel configuration");
        }
        return this.processManager;
    }

    public ExecutionManager getExecutionManager() {
        if (this.executionManager == null) {
            throw new IllegalStateException("ExecutionManager not available through kernel configuration");
        }
        return this.executionManager;
    }

    public SignalManager getSignalManager() {
        if (this.signalManager == null) {
            throw new IllegalStateException("SignalManager not available through kernel configuration");
        }
        return this.signalManager;
    }

    public MessageManager getMessageManager() {
        if (this.messageManager == null) {
            throw new IllegalStateException("MessageManager not available through kernel configuration");
        }
        return this.messageManager;
    }
}

