/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.client.internal;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.BPMException;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.plugins.util.KernelLocator;

public class EmbeddedBeansDeployer
extends BasicBootstrap {
    private static final Log log = LogFactory.getLog(EmbeddedBeansDeployer.class);
    private Kernel kernel = KernelLocator.getKernel();
    private BasicXMLDeployer deployer;

    public EmbeddedBeansDeployer() {
        if (this.kernel == null) {
            try {
                this.kernel = super.getKernel();
                log.debug((Object)("bootstrap kernel: " + this.kernel));
            }
            catch (Throwable e) {
                throw new BPMException("Cannot bootstrap kernel", e);
            }
        }
        this.deployer = new BasicXMLDeployer(this.kernel);
    }

    public void deploy(URL url) {
        log.debug((Object)("deploy: " + url));
        try {
            this.deployer.deploy(url);
            this.deployer.validate();
            if (KernelLocator.getKernel() == null) {
                throw new BPMException("KernelLocator not deployed as MC bean");
            }
        }
        catch (Throwable e) {
            throw new BPMException("Cannot deploy beans from: " + url, e);
        }
    }

    public void undeploy(URL url) {
        log.debug((Object)("undeploy: " + url));
        try {
            this.deployer.undeploy(url);
        }
        catch (Throwable e) {
            throw new BPMException("Cannot undeploy beans from: " + url, e);
        }
    }
}

