/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.model;

import java.io.Serializable;
import javax.management.ObjectName;

public final class Signal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SignalType type;
    private String message;
    private ObjectName fromRef;

    public Signal(ObjectName fromRef, SignalType type) {
        this.fromRef = fromRef;
        this.type = type;
        if (fromRef == null) {
            throw new IllegalArgumentException("Signal fromRef cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("SignalType cannot be null");
        }
    }

    public Signal(ObjectName fromRef, SignalType type, String message) {
        this(fromRef, type);
        this.message = message;
    }

    public ObjectName getFromRef() {
        return this.fromRef;
    }

    public SignalType getSignalType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder string = new StringBuilder((Object)((Object)this.type) + "[" + this.fromRef);
        if (this.message != null) {
            string.append(":" + this.message);
        }
        string.append("]");
        return string.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignalType {
        SYSTEM_START_EVENT_ENTER,
        SYSTEM_START_EVENT_EXIT,
        SYSTEM_START_TRIGGER,
        SYSTEM_EVENT_ENTER,
        SYSTEM_EVENT_EXIT,
        SYSTEM_EVENT_TRIGGER,
        SYSTEM_END_EVENT_ENTER,
        SYSTEM_END_EVENT_EXIT,
        SYSTEM_END_TRIGGER,
        SYSTEM_GATEWAY_ENTER,
        SYSTEM_GATEWAY_EXIT,
        SYSTEM_PROCESS_ENTER,
        SYSTEM_PROCESS_EXIT,
        SYSTEM_SUB_PROCESS_ENTER,
        SYSTEM_SUB_PROCESS_EXIT,
        SYSTEM_TASK_ENTER,
        SYSTEM_TASK_EXIT,
        SYSTEM_TASK_TRIGGER,
        USER_SIGNAL;

    }
}

