/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.cts.processmanager;

// $Id: ProcessManagerTest.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.client.SignalListener;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.Signal.SignalType;
import org.jboss.bpm.test.DefaultEngineTestCase;

/**
 * Test the ProcessManager
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class ProcessManagerTest extends DefaultEngineTestCase
{
  public void testStartProcess() throws Exception
  {
    final Process proc = getProcess();
    final ObjectName procID = proc.getID();

    final ProcessManager pm = ProcessManager.locateProcessManager();
    assertNull("A process created through the builder is not registered automatically", pm.getProcessByID(procID));

    SignalListener sigListener = new SignalListener()
    {
      public boolean acceptSignal(Signal signal)
      {
        return signal.getSignalType() == SignalType.SYSTEM_TASK_ENTER;
      }

      public void catchSignal(Signal signal)
      {
        assertNotNull(pm.getProcessByID(procID));
      }
    };
    SignalManager sigManager = SignalManager.locateSignalManager();
    sigManager.addSignalListener(sigListener);

    try
    {
      // Start the process, which automatically adds it to the registery
      assertEquals(procID, proc.startProcess());
      proc.waitForEnd();
    }
    finally
    {
      sigManager.removeSignalListener(sigListener);
    }

    assertNull("A terminated process is removed from the registry", pm.getProcessByID(procID));
  }

  private Process getProcess()
  {
    ProcessBuilder builder = ProcessBuilderFactory.newInstance().newProcessBuilder();
    builder.addProcess(getName()).addStartEvent("Start").addSequenceFlow("taskA");
    Process proc = builder.addTask("taskA").addSequenceFlow("end").addEndEvent("end").getProcess();
    return proc;
  }
}
