/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

// $Id: JAXBFlow.java 1794 2008-07-31 16:15:38Z thomas.diesler@jboss.com $

/**
 * A Flow is a graphical line connecting two objects in a BPD.
 * 
 * There are two types of Flow: Sequence Flow and Message Flow, each with their own line style. Flow is also used in a
 * generic sense (and lowercase) to describe how Tokens will traverse Sequence Flow from the Start Event to an End
 * Event.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Flow")
public class JAXBFlow extends JAXBGraphicalElement
{
  private String name;
  private String targetName;

  public String getName()
  {
    return name;
  }

  @XmlAttribute(required = false)
  public void setName(String name)
  {
    this.name = name;
  }

  public String getTargetName()
  {
    return targetName;
  }

  @XmlAttribute(name = "to", required = true)
  public void setTargetName(String targetName)
  {
    this.targetName = targetName;
  }
}