/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBProcess.java 1910 2008-08-17 10:16:05Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * A Process is any Activity performed within a company or organization.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "Process")
@XmlRootElement(name = "process")
public class JAXBProcess extends JAXBSupportingElement
{
  private String name;
  private List<JAXBMessage> messages = new ArrayList<JAXBMessage>();
  private List<JAXBInclude> includes = new ArrayList<JAXBInclude>();

  @XmlElements( { @XmlElement(name = "start", type = JAXBStartEvent.class),
      @XmlElement(name = "event", type = JAXBIntermediateEvent.class),
      @XmlElement(name = "task", type = JAXBTask.class),
      @XmlElement(name = "exclusive-gateway", type = JAXBExclusiveGateway.class),
      @XmlElement(name = "inclusive-gateway", type = JAXBInclusiveGateway.class),
      @XmlElement(name = "complex-gateway", type = JAXBComplexGateway.class),
      @XmlElement(name = "parallel-gateway", type = JAXBParallelGateway.class),
      @XmlElement(name = "sub-process", type = JAXBSubProcess.class),
      @XmlElement(name = "end", type = JAXBEndEvent.class) })
  private List<JAXBFlowObject> flowObjects = new ArrayList<JAXBFlowObject>();

  private List<JAXBProperty> properties = new ArrayList<JAXBProperty>();
  private List<JAXBAssignment> assignments = new ArrayList<JAXBAssignment>();

  public String getName()
  {
    return name;
  }

  @XmlAttribute
  public void setName(String name)
  {
    this.name = name;
  }

  public List<JAXBFlowObject> getFlowObjects()
  {
    return flowObjects;
  }

  public List<JAXBMessage> getMessages()
  {
    return messages;
  }

  @XmlElement(name = "message")
  public void setMessages(List<JAXBMessage> messages)
  {
    this.messages = messages;
  }

  public List<JAXBInclude> getIncludes()
  {
    return includes;
  }

  @XmlElement(name = "include")
  public void setIncludes(List<JAXBInclude> includes)
  {
    this.includes = includes;
  }

  public JAXBMessage getMessageByName(String msgName)
  {
    for (JAXBMessage msg : messages)
    {
      if (msg.getName().equals(msgName))
        return msg;
    }
    return null;
  }

  @XmlElement(name = "property")
  public List<JAXBProperty> getProperties()
  {
    return properties;
  }

  @XmlElement(name = "assignment")
  public List<JAXBAssignment> getAssignments()
  {
    return assignments;
  }
}