/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.api10.model;

//$Id: JAXBStartEvent.java 1889 2008-08-14 13:29:28Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * A Start Event indicates where a particular Process will start. In terms of Sequence Flow, the Start Event starts the
 * Flow of the Process, and thus, will not have any incoming Sequence Flow. A Start Event can have a Trigger that
 * indicates how the Process starts: Message, Timer, Rule, Link, or Multiple.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@XmlType(name = "AbstractStartEvent", propOrder = { "outFlow", "trigger" })
public class JAXBStartEvent extends JAXBEvent
{
  @XmlElements( { 
    @XmlElement(name = "seqflow", type = JAXBSequenceFlow.class),
    @XmlElement(name = "msgflow", type = JAXBMessageFlow.class) })
  private JAXBFlow outFlow;

  @XmlElements( { 
    @XmlElement(name = "signal-trigger", type = JAXBSignalEventDetail.class)
    })
  private List<JAXBEventDetail> trigger = new ArrayList<JAXBEventDetail>();

  private String name;

  public String getName()
  {
    return name;
  }

  @XmlAttribute(required = false)
  public void setName(String name)
  {
    this.name = name;
  }
  
  public JAXBFlow getOutFlow()
  {
    return outFlow;
  }

  @XmlTransient
  public void setOutFlow(JAXBFlow outFlow)
  {
    this.outFlow = outFlow;
  }

  public List<JAXBEventDetail> getTrigger()
  {
    return trigger;
  }

  @XmlTransient
  public void setTrigger(List<JAXBEventDetail> trigger)
  {
    this.trigger = trigger;
  }
}