/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.jpdl32;

import java.util.List;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32Action;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32EndState;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32Event;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32Fork;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32ProcessDefinition;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32StartState;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32State;
import org.jboss.bpm.dialect.jpdl32.model.JPDL32Transition;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.runtime.ExecutionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionAdapter {
    public Process adaptProcessDefinition(JPDL32ProcessDefinition jpdlProcDef) {
        ProcessBuilder builder = ProcessBuilderFactory.newInstance().newProcessBuilder();
        builder.addProcess(jpdlProcDef.getName());
        for (Object jpdlObj : jpdlProcDef.getDescriptionOrSwimlaneOrStartState()) {
            if (jpdlObj instanceof JPDL32StartState) {
                this.adaptStartState(builder, (JPDL32StartState)jpdlObj);
                continue;
            }
            if (jpdlObj instanceof JPDL32State) {
                this.adaptState(builder, (JPDL32State)jpdlObj);
                continue;
            }
            if (jpdlObj instanceof JPDL32Fork) {
                this.adaptFork(builder, (JPDL32Fork)jpdlObj);
                continue;
            }
            if (jpdlObj instanceof JPDL32EndState) {
                this.adaptEndState(builder, (JPDL32EndState)jpdlObj);
                continue;
            }
            throw new InvalidProcessException("Unsupported type: " + jpdlObj);
        }
        Process proc = builder.getProcess();
        return proc;
    }

    private void adaptStartState(ProcessBuilder builder, JPDL32StartState jpdlStart) {
        builder.addStartEvent("Start");
        this.adaptTransitions(builder, jpdlStart.getDescriptionOrTaskOrTransition());
    }

    private void adaptEndState(ProcessBuilder builder, JPDL32EndState jpdlEnd) {
        builder.addEndEvent(jpdlEnd.getName());
    }

    private void adaptState(ProcessBuilder builder, JPDL32State jpdlState) {
        builder.addTask(jpdlState.getName(), Task.TaskType.None);
        this.adaptTransitions(builder, jpdlState.getDescriptionOrEventOrExceptionHandler());
        for (Object jpdlObj : jpdlState.getDescriptionOrEventOrExceptionHandler()) {
            JPDL32Event jpdlEvent;
            if (!(jpdlObj instanceof JPDL32Event) || !(jpdlEvent = (JPDL32Event)jpdlObj).getType().equals("node-enter")) continue;
            for (Object jpdlAux : jpdlEvent.getActionOrScriptOrCreateTimer()) {
                if (!(jpdlAux instanceof JPDL32Action)) continue;
                JPDL32Action jpdlAction = (JPDL32Action)jpdlAux;
                Class<?> handler = this.loadHandler(jpdlAction.getClazz());
                if (!ExecutionHandler.class.isAssignableFrom(handler)) {
                    throw new InvalidProcessException("Node action is not of type ExecutionHandler");
                }
                builder.addExecutionHandler(handler);
            }
        }
    }

    private void adaptFork(ProcessBuilder builder, JPDL32Fork jpdlObj) {
        builder.addGateway(jpdlObj.getName(), Gateway.GatewayType.Parallel);
        this.adaptTransitions(builder, jpdlObj.getScriptOrDescriptionOrEvent());
    }

    private void adaptTransitions(ProcessBuilder builder, List<Object> list) {
        for (Object subEl : list) {
            if (!(subEl instanceof JPDL32Transition)) continue;
            JPDL32Transition trans = (JPDL32Transition)subEl;
            String targetName = trans.getTo();
            builder.addSequenceFlow(targetName);
        }
    }

    private Class<?> loadHandler(String className) {
        try {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            return ctxLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load handler class: " + className);
        }
    }
}

