/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.stp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.dialect.stp.model.Activity;
import org.jboss.bpm.dialect.stp.model.ActivityType;
import org.jboss.bpm.dialect.stp.model.BpmnDiagram;
import org.jboss.bpm.dialect.stp.model.ObjectFactory;
import org.jboss.bpm.dialect.stp.model.Pool;
import org.jboss.bpm.dialect.stp.model.SequenceEdge;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;
import org.jboss.bpm.model.Task;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessUnmarshaller {
    public static final String NAMESPACE_URI = "http://stp.eclipse.org/bpmn";
    private BpmnDiagram diagram;
    private List<SequenceEdge> sequenceEdges;
    private List<Activity> activities = new ArrayList<Activity>();

    public Process unmarshallProcess(InputStream xml, boolean isInclude) throws JAXBException {
        Document doc;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setProperty("com.sun.xml.bind.ObjectFactory", (Object)new ObjectFactory());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(xml);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot parse stpbpmn", ex);
        }
        Element root = doc.getDocumentElement();
        this.diagram = (BpmnDiagram)unmarshaller.unmarshal((Node)root, BpmnDiagram.class).getValue();
        ProcessBuilder procBuilder = this.adaptDiagram(this.diagram);
        Element poolEl = (Element)DOMUtils.getChildElements((Node)root, (String)"pools").next();
        Pool pool = (Pool)unmarshaller.unmarshal((Node)poolEl, Pool.class).getValue();
        this.sequenceEdges = pool.getSequenceEdges();
        Iterator itEl = DOMUtils.getChildElements((Node)poolEl, (String)"vertices");
        while (itEl.hasNext()) {
            Element stpEl = (Element)itEl.next();
            String xmiType = DOMUtils.getAttributeValue((Element)stpEl, (QName)new QName("http://www.omg.org/XMI", "type"));
            if ("bpmn:Activity".equals(xmiType)) {
                String edgeStr;
                Activity stpActivity = (Activity)unmarshaller.unmarshal((Node)stpEl, Activity.class).getValue();
                String name = DOMUtils.getAttributeValue((Element)stpEl, (String)"name");
                name = name != null ? name : stpActivity.getId();
                stpActivity.setLabel(name);
                List<String> outEdges = stpActivity.getOutgoingEdges();
                if (outEdges.size() == 0 && (edgeStr = DOMUtils.getAttributeValue((Element)stpEl, (String)"outgoingEdges")) != null && edgeStr.length() > 0) {
                    outEdges.add(edgeStr);
                }
                this.activities.add(stpActivity);
                continue;
            }
            throw new IllegalStateException("Unsupported xmi:type: " + xmiType);
        }
        for (Activity stpActivity : this.activities) {
            this.adaptActivity(procBuilder, stpActivity);
        }
        Process proc = isInclude ? procBuilder.getProcessForInclude() : procBuilder.getProcess();
        return proc;
    }

    private ProcessBuilder adaptDiagram(BpmnDiagram bpmnDiagram) {
        List<Pool> stpPools = bpmnDiagram.getPools();
        if (stpPools == null || stpPools.size() == 0) {
            throw new IllegalStateException("Expected at least one Pool");
        }
        if (stpPools.size() > 1) {
            throw new IllegalStateException("Multiple Pools not supported");
        }
        Pool stpPool = stpPools.get(0);
        ProcessBuilder builder = ProcessBuilderFactory.newInstance().newProcessBuilder();
        builder.addProcess(stpPool.getId());
        return builder;
    }

    private void adaptActivity(ProcessBuilder builder, Activity stpActivity) {
        ActivityType activityType = stpActivity.getActivityType();
        if (activityType == ActivityType.EVENT_START_EMPTY) {
            builder.addStartEvent("Start");
            this.adaptOutgoingEdges(builder, stpActivity);
        } else if (activityType == ActivityType.EVENT_END_EMPTY) {
            String name = stpActivity.getLabel();
            builder.addEndEvent(name);
        } else if (activityType == ActivityType.TASK) {
            String name = stpActivity.getLabel();
            Task.TaskType taskType = Task.TaskType.None;
            if (name.startsWith("Send")) {
                taskType = Task.TaskType.Send;
            }
            if (name.startsWith("Receive")) {
                taskType = Task.TaskType.Receive;
            }
            builder.addTask(name, taskType);
            this.adaptOutgoingEdges(builder, stpActivity);
        } else if (activityType == ActivityType.GATEWAY_DATA_BASED_EXCLUSIVE) {
            String name = stpActivity.getLabel();
            builder.addGateway(name, Gateway.GatewayType.Exclusive);
            this.adaptOutgoingEdges(builder, stpActivity);
        } else if (activityType == ActivityType.GATEWAY_PARALLEL) {
            String name = stpActivity.getLabel();
            builder.addGateway(name, Gateway.GatewayType.Parallel);
            this.adaptOutgoingEdges(builder, stpActivity);
        } else {
            throw new InvalidProcessException("Unsupported activity type: " + (Object)((Object)activityType));
        }
    }

    private void adaptOutgoingEdges(ProcessBuilder builder, Activity stpActivity) {
        for (String edgeIds : stpActivity.getOutgoingEdges()) {
            String[] edgeIdArr;
            for (String edgeId : edgeIdArr = edgeIds.split("\\s")) {
                SequenceEdge seqEdge = this.getSequenceEdgeById(edgeId);
                String targetId = seqEdge.getTarget();
                Activity targetAct = this.getActivityById(targetId);
                String targetName = targetAct.getLabel();
                builder.addSequenceFlow(targetName);
            }
        }
    }

    private SequenceEdge getSequenceEdgeById(String edgeId) {
        for (SequenceEdge seqEdge : this.sequenceEdges) {
            if (!seqEdge.getId().equals(edgeId)) continue;
            return seqEdge;
        }
        throw new InvalidProcessException("Cannot find SequenceEdge: " + edgeId);
    }

    private Activity getActivityById(String id) {
        for (Activity act : this.activities) {
            if (!act.getId().equals(id)) continue;
            return act;
        }
        throw new InvalidProcessException("Cannot find Activity: " + id);
    }
}

