/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import org.jboss.bpm.model.Activity;
import org.jboss.bpm.model.ActivityBuilder;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.ri.model.impl.ActivityImpl;
import org.jboss.bpm.ri.model.impl.ExpressionImpl;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.InputSetImpl;
import org.jboss.bpm.ri.model.impl.OutputSetImpl;
import org.jboss.bpm.ri.model.impl.ProcessBuilderImpl;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.model.impl.PropertyImpl;

public class ActivityBuilderImpl
extends ProcessBuilderImpl
implements ActivityBuilder {
    private InputSetImpl inputSet;
    private OutputSetImpl outputSet;

    public ActivityBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject) {
        super(proc, flowObject);
    }

    public ActivityBuilder addInputSet() {
        this.inputSet = new InputSetImpl();
        this.getActivity().addInputSet(this.inputSet);
        return this;
    }

    public ActivityBuilder addPropertyInput(String name) {
        PropertyImpl prop = new PropertyImpl(name, null);
        this.inputSet.addProperty(prop);
        return this;
    }

    public ActivityBuilder addOutputSet() {
        this.outputSet = new OutputSetImpl();
        this.getActivity().addOutputSet(this.outputSet);
        return this;
    }

    public ActivityBuilder addPropertyOutput(String name, String value) {
        PropertyImpl prop = new PropertyImpl(name, new ExpressionImpl(value));
        this.outputSet.addProperty(prop);
        return this;
    }

    public ActivityBuilder addIORule(String body, Expression.ExpressionLanguage lang) {
        ExpressionImpl expr = new ExpressionImpl(lang, body);
        this.getActivity().addIORule(expr);
        return this;
    }

    public ActivityBuilder addProperty(String name, String value) {
        PropertyImpl prop = new PropertyImpl(name, new ExpressionImpl(Expression.ExpressionLanguage.String, value));
        this.getActivity().addProperty(prop);
        return this;
    }

    private ActivityImpl getActivity() {
        if (!(this.flowObject instanceof Activity)) {
            throw new IllegalStateException("Last added flow object is not a Activity");
        }
        return (ActivityImpl)this.flowObject;
    }
}

