/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.Activity;
import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.MutablePropertySupport;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.model.impl.ExpressionImpl;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.InputSetImpl;
import org.jboss.bpm.ri.model.impl.OutputSetImpl;
import org.jboss.bpm.ri.model.impl.PropertyImpl;
import org.jboss.bpm.ri.model.impl.SingleInFlowSetterSupport;
import org.jboss.bpm.ri.model.impl.SingleOutFlowSetterSupport;
import org.jboss.bpm.ri.runtime.MutableToken;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityImpl
extends FlowObjectImpl
implements Activity,
MutablePropertySupport,
SingleInFlowSetterSupport,
SingleOutFlowSetterSupport {
    private static final Log log = LogFactory.getLog(ActivityImpl.class);
    private List<InputSet> inputSets = new ArrayList<InputSet>();
    private List<OutputSet> outputSets = new ArrayList<OutputSet>();
    private List<Expression> ioRules = new ArrayList<Expression>();
    private List<Property> props = new ArrayList<Property>();
    private SequenceFlow inFlow;
    private SequenceFlow outFlow;

    public ActivityImpl(String name) {
        super(name);
    }

    public int getStartQuantity() {
        throw new NotImplementedException("JBPM-1631", "Activity startQuantity");
    }

    public int getCompletionQuantity() {
        throw new NotImplementedException("JBPM-1632", "Activity completionQuantity");
    }

    public List<Expression> getIORules() {
        return Collections.unmodifiableList(this.ioRules);
    }

    public void addIORule(Expression expr) {
        this.ioRules.add(expr);
    }

    public List<InputSet> getInputSets() {
        return Collections.unmodifiableList(this.inputSets);
    }

    public void addInputSet(InputSet inputSet) {
        this.inputSets.add(inputSet);
    }

    public List<OutputSet> getOutputSets() {
        return Collections.unmodifiableList(this.outputSets);
    }

    public void addOutputSet(OutputSet outputSet) {
        this.outputSets.add(outputSet);
    }

    public Activity.LoopType getLoopType() {
        throw new NotImplementedException("JBPM-1633", "Activity loopType");
    }

    public List<String> getPerformers() {
        throw new NotImplementedException("JBPM-1634", "Activity Performers");
    }

    public Property getProperty(String name) {
        for (Property prop : this.props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public Object getPropertyValue(String name) {
        Property prop = this.getProperty(name);
        return prop != null ? prop.getValue() : null;
    }

    public <T> T getPropertyValue(Class<T> clazz, String name) {
        Property prop = this.getProperty(name);
        return (T)(prop != null ? prop.getValue(clazz) : null);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.props);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Property prop : this.props) {
            names.add(prop.getName());
        }
        return names;
    }

    public void addProperty(Property prop) {
        this.props.add(prop);
    }

    public ConnectingObject getInFlow() {
        return this.inFlow;
    }

    @Override
    public void setInFlow(SequenceFlow inFlow) {
        this.inFlow = inFlow;
    }

    public SequenceFlow getOutFlow() {
        return this.outFlow;
    }

    @Override
    public void setOutFlow(SequenceFlow flow) {
        this.outFlow = flow;
    }

    @Override
    public void execute(Token token) {
        MutableToken mutableToken = (MutableToken)token;
        mutableToken.setOutputSet(this.getActiveOutputSet());
        mutableToken.setInputSet(this.getActiveInputSet(token));
        super.execute(token);
        this.processOutputSet(token);
        this.postProcessInputSet(token);
    }

    protected InputSet getActiveInputSet(Token token) {
        InputSetImpl inputSet = null;
        ExecutionContext exContext = token.getExecutionContext();
        if (this.inputSets.size() > 0) {
            for (InputSet auxSet : this.inputSets) {
                boolean allInputPropsInContext = true;
                for (Property prop : auxSet.getProperties()) {
                    Object att = exContext.getAttachment(prop.getName());
                    allInputPropsInContext &= att != null;
                }
                if (!allInputPropsInContext) continue;
                inputSet = new InputSetImpl();
                for (Property prop : auxSet.getProperties()) {
                    String name = prop.getName();
                    Object value = exContext.getAttachment(name);
                    inputSet.addProperty(new PropertyImpl(name, new ExpressionImpl(value)));
                }
            }
            if (inputSet == null) {
                log.warn((Object)("InputSets: " + this.inputSets));
                throw new IllegalStateException("Cannot find matching inputSet for " + exContext + " in Activity: " + this.getName());
            }
        }
        if (inputSet == null) {
            inputSet = new InputSetImpl();
        }
        return inputSet;
    }

    protected OutputSet getActiveOutputSet() {
        OutputSetImpl outputSet = null;
        if (this.outputSets.size() > 0) {
            if (this.outputSets.size() > 1) {
                throw new NotImplementedException("JBPM-1635", "IORules and multiple outputSets");
            }
            outputSet = new OutputSetImpl();
            for (Property prop : this.outputSets.get(0).getProperties()) {
                outputSet.addProperty(prop);
            }
        }
        if (outputSet == null) {
            outputSet = new OutputSetImpl();
        }
        return outputSet;
    }

    protected void processOutputSet(Token token) {
        ExecutionContext exContext = token.getExecutionContext();
        OutputSet outputSet = token.getOutputSet();
        for (Property prop : this.getActiveOutputSet().getProperties()) {
            Property outProp = outputSet.getProperty(prop.getName());
            if (outProp == null) {
                throw new IllegalStateException("Cannot find outputSet property '" + prop.getName() + "' in Activity: " + this.getName());
            }
            String name = outProp.getName();
            Object value = outProp.getValue();
            exContext.addAttachment(name, value);
        }
    }

    protected void postProcessInputSet(Token token) {
    }

    @Override
    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        tokenExecutor.move(token, this.getOutFlow());
    }

    @Override
    protected void create(Process proc) {
        int propSize;
        int artSize;
        super.create(proc);
        for (InputSet inSet : this.inputSets) {
            artSize = inSet.getArtifactInputs().size();
            propSize = inSet.getProperties().size();
            if (artSize != 0 || propSize != 0) continue;
            throw new InvalidProcessException("For the combination of ArtifactInputs and PropertyInputs, there MUST be at least one item defined for the InputSet");
        }
        for (OutputSet outSet : this.outputSets) {
            artSize = outSet.getArtifactOutputs().size();
            propSize = outSet.getProperties().size();
            if (artSize != 0 || propSize != 0) continue;
            throw new InvalidProcessException("For the combination of ArtifactOutputs and PropertyOututs, there MUST be at least one item defined for the OutputSet");
        }
    }
}

