/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.EndEvent;
import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.MessageEventDetail;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.ri.model.impl.EventDetailImpl;
import org.jboss.bpm.ri.model.impl.EventImpl;
import org.jboss.bpm.ri.model.impl.MessageSender;
import org.jboss.bpm.ri.model.impl.SingleInFlowSetterSupport;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;
import org.jboss.util.id.UID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndEventImpl
extends EventImpl
implements EndEvent,
SingleInFlowSetterSupport {
    private static final Log log = LogFactory.getLog(EndEventImpl.class);
    private List<EventDetail> resultSet = new ArrayList<EventDetail>();
    private SequenceFlow inFlow;

    public EndEventImpl(String name) {
        super(name);
    }

    @Override
    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("jboss.bpm:");
            str.append("type=EndEvent,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public SequenceFlow getInFlow() {
        return this.inFlow;
    }

    @Override
    public void setInFlow(SequenceFlow inFlow) {
        this.inFlow = inFlow;
    }

    public void addResult(EventDetail result) {
        this.resultSet.add(result);
    }

    public List<EventDetail> getResult() {
        return Collections.unmodifiableList(this.resultSet);
    }

    @Override
    protected void defaultExecution(Token token) {
        super.defaultExecution(token);
        for (EventDetail eventDetail : this.getResult()) {
            if (eventDetail.getEventDetailType() != EventDetail.EventDetailType.Message) continue;
            MessageEventDetail msgEventDetail = (MessageEventDetail)eventDetail;
            MessageSender messageSender = new MessageSender(this, msgEventDetail.getMessageRef());
            messageSender.sendMessage(token);
        }
    }

    @Override
    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        log.debug((Object)("End reached in: " + this.getName()));
        ExecutionContext exContext = token.getExecutionContext();
        exContext.addAttachment(EndSignalCallback.class, (Object)new EndSignalCallback(tokenExecutor));
    }

    @Override
    public SignalHandler getSignalHandler() {
        SignalHandler handler = super.getSignalHandler();
        if (handler == null) {
            handler = new SignalHandler(){
                SignalManager signalManager = SignalManager.locateSignalManager();

                public void throwEnterSignal(Token token) {
                    Signal signal = new Signal(EndEventImpl.this.getID(), Signal.SignalType.SYSTEM_END_EVENT_ENTER);
                    this.signalManager.throwSignal(signal);
                }

                public void throwExitSignal(Token token) {
                    Signal signal = new Signal(EndEventImpl.this.getID(), Signal.SignalType.SYSTEM_END_EVENT_EXIT);
                    this.signalManager.throwSignal(signal);
                    ExecutionContext exContext = token.getExecutionContext();
                    EndSignalCallback callback = (EndSignalCallback)exContext.getAttachment(EndSignalCallback.class);
                    callback.destroyToken(token);
                }
            };
        }
        return handler;
    }

    @Override
    protected void create(Process proc) {
        super.create(proc);
        for (EventDetail result : this.getResult()) {
            EventDetailImpl resultImpl = (EventDetailImpl)result;
            resultImpl.initialize(this);
        }
    }

    public String toString() {
        return "EndEvent[" + this.getName() + "]";
    }

    static class EndSignalCallback {
        TokenExecutor tokenExecutor;

        public EndSignalCallback(TokenExecutor tokenExecutor) {
            this.tokenExecutor = tokenExecutor;
        }

        void destroyToken(Token token) {
            this.tokenExecutor.destroy(token);
        }
    }
}

