/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.ExclusiveGateway;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.model.impl.ExpressionEvaluator;
import org.jboss.bpm.ri.model.impl.GatewayImpl;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

public abstract class ExclusiveGatewayImpl
extends GatewayImpl
implements ExclusiveGateway {
    private static final Log log = LogFactory.getLog(ExclusiveGatewayImpl.class);
    private Set<ConnectingObject> outstandingFlows;

    public ExclusiveGatewayImpl(String name) {
        super(name);
    }

    public Gateway.GatewayType getGatewayType() {
        return Gateway.GatewayType.Exclusive;
    }

    public void addInFlow(ConnectingObject inFlow) {
        super.addInFlow(inFlow);
    }

    public void defaultExecution(Token token) {
        super.defaultExecution(token);
        if (this.outstandingFlows == null) {
            this.outstandingFlows = new HashSet<ConnectingObject>(this.inFlows);
        }
        SequenceFlow flow = token.getFlow();
        this.outstandingFlows.remove(flow);
    }

    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        FlowObject sourceRef = token.getFlow().getSourceRef();
        if (token == this.receivedTokens.get(0)) {
            log.debug((Object)("Propagate token comming from: " + sourceRef));
            Gate selectedGate = this.getSelectedGate(token);
            SequenceFlow outFlow = selectedGate.getOutgoingSequenceFlow();
            tokenExecutor.move(token, outFlow);
        } else {
            log.debug((Object)("Ignore token comming from: " + sourceRef));
            tokenExecutor.destroy(token);
        }
        if (this.outstandingFlows.size() == 0) {
            this.reset();
        }
    }

    public void reset() {
        super.reset();
        this.outstandingFlows = null;
    }

    private Gate getSelectedGate(Token token) {
        Gate auxGate;
        SequenceFlow seqFlow;
        SequenceFlow seqFlow2;
        Gate selectedGate = null;
        for (Gate auxGate2 : this.getGates()) {
            Expression expr;
            ExpressionEvaluator exprEvaluator;
            seqFlow2 = auxGate2.getOutgoingSequenceFlow();
            if (seqFlow2.getConditionType() != SequenceFlow.ConditionType.Expression || !((Boolean)(exprEvaluator = new ExpressionEvaluator(expr = seqFlow2.getConditionExpression())).evaluateExpression(token)).booleanValue()) continue;
            selectedGate = auxGate2;
            break;
        }
        if (selectedGate == null) {
            for (Gate auxGate2 : this.getGates()) {
                seqFlow2 = auxGate2.getOutgoingSequenceFlow();
                if (seqFlow2.getConditionType() != SequenceFlow.ConditionType.Default) continue;
                selectedGate = auxGate2;
                break;
            }
        }
        if (selectedGate == null && this.getGates().size() == 1 && (seqFlow = (auxGate = this.getGates().get(0)).getOutgoingSequenceFlow()).getConditionType() == SequenceFlow.ConditionType.None) {
            selectedGate = auxGate;
        }
        if (selectedGate == null) {
            throw new IllegalStateException("Cannot select applicable gate in: " + this);
        }
        return selectedGate;
    }

    public String toString() {
        return "ExclusiveGateway[" + this.getName() + "]";
    }
}

