/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.MultipleInFlowSetterSupport;
import org.jboss.bpm.runtime.ExecutionHandler;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.util.id.UID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GatewayImpl
extends FlowObjectImpl
implements Gateway,
MultipleInFlowSetterSupport {
    protected List<ConnectingObject> inFlows = new ArrayList<ConnectingObject>();
    private Map<String, Gate> gates = new LinkedHashMap<String, Gate>();
    protected List<ConnectingObject> expectedFlows;
    protected List<Token> receivedTokens;

    public GatewayImpl(String name) {
        super(name);
    }

    @Override
    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("jboss.bpm:");
            str.append("type=" + this.getGatewayType() + "Gateway,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public List<Gate> getGates() {
        return Collections.unmodifiableList(new ArrayList<Gate>(this.gates.values()));
    }

    public void addGate(Gate gate) {
        String targetName = gate.getOutgoingSequenceFlow().getTargetName();
        this.gates.put(targetName, gate);
    }

    @Override
    public List<ConnectingObject> getInFlows() {
        return Collections.unmodifiableList(this.inFlows);
    }

    @Override
    public void addInFlow(ConnectingObject inFlow) {
        this.inFlows.add(inFlow);
    }

    public Gate getDefaultGate() {
        Gate gate = null;
        for (Gate aux : this.gates.values()) {
            SequenceFlow seqFlow = aux.getOutgoingSequenceFlow();
            if (seqFlow.getConditionType() != SequenceFlow.ConditionType.Default) continue;
            gate = aux;
            break;
        }
        return gate;
    }

    public Gate getGateByTargetName(String targetName) {
        Gate gate = this.gates.get(targetName);
        return gate;
    }

    @Override
    public void defaultExecution(Token token) {
        SequenceFlow flow;
        if (this.expectedFlows == null) {
            this.expectedFlows = new ArrayList<ConnectingObject>(this.inFlows);
            this.receivedTokens = new ArrayList<Token>();
        }
        if (!this.expectedFlows.contains(flow = token.getFlow())) {
            throw new IllegalStateException("Unexpected token from: " + flow);
        }
        ExecutionHandler exHandler = this.getExecutionHandler();
        if (exHandler != null) {
            exHandler.execute(token);
        }
        this.expectedFlows.remove(flow);
        this.receivedTokens.add(token);
    }

    @Override
    public void reset() {
        super.reset();
        this.expectedFlows = null;
        this.receivedTokens = null;
    }

    @Override
    public SignalHandler getSignalHandler() {
        SignalHandler handler = super.getSignalHandler();
        if (handler == null) {
            handler = new SignalHandler(){
                SignalManager signalManager = SignalManager.locateSignalManager();

                public void throwEnterSignal(Token token) {
                    Signal signal = new Signal(GatewayImpl.this.getID(), Signal.SignalType.SYSTEM_GATEWAY_ENTER);
                    this.signalManager.throwSignal(signal);
                }

                public void throwExitSignal(Token token) {
                    Signal signal = new Signal(GatewayImpl.this.getID(), Signal.SignalType.SYSTEM_GATEWAY_EXIT);
                    this.signalManager.throwSignal(signal);
                }
            };
        }
        return handler;
    }
}

