/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.MessageListener;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.model.ReceiveTask;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.model.impl.TaskImpl;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

public class ReceiveTaskImpl
extends TaskImpl
implements ReceiveTask,
MessageListener {
    private static final Log log = LogFactory.getLog(ReceiveTaskImpl.class);
    private Message.Implementation implementation = Message.Implementation.WebService;
    private Message messageRef;
    private List<Message> receivedMessages = new ArrayList<Message>();
    private List<Token> suspendedTokens = new ArrayList<Token>();

    public ReceiveTaskImpl(String name) {
        super(name);
    }

    public Task.TaskType getTaskType() {
        return Task.TaskType.Receive;
    }

    public Message.Implementation getImplementation() {
        return this.implementation;
    }

    public Message getMessageRef() {
        return this.messageRef;
    }

    public void setMessageRef(Message message) {
        this.messageRef = message;
    }

    public boolean isInstantiate() {
        throw new NotImplementedException("JBPM-1648", "ReceiveTask Instantiate");
    }

    public synchronized void catchMessage(Message message) {
        String msgName = message.getName();
        if (this.messageRef.getName().equals(msgName)) {
            log.debug((Object)("catchMessage in " + this + " => " + message));
            for (Property prop : this.messageRef.getProperties()) {
                String name = prop.getName();
                if (message.getProperty(name) != null) continue;
                throw new IllegalArgumentException("Received message does not contain expected property: " + name);
            }
            this.receivedMessages.add(message);
            if (this.suspendedTokens.size() == 0) {
                log.debug((Object)("Suspend message: " + message));
            } else {
                Token token = this.suspendedTokens.remove(0);
                ExecutionContext exContext = token.getExecutionContext();
                TokenExecutor tokenExecutor = (TokenExecutor)exContext.removeAttachment(TokenExecutor.class);
                tokenExecutor.activate(token.getTokenID());
            }
        } else {
            log.debug((Object)("Ignore unexpected message: " + message));
        }
    }

    public synchronized void defaultExecution(Token token) {
        if (this.receivedMessages.size() > 0) {
            Message msg = this.receivedMessages.get(0);
            ExecutionContext exContext = token.getExecutionContext();
            for (Property prop : this.messageRef.getProperties()) {
                String key = prop.getName();
                Object value = msg.getPropertyValue(key);
                exContext.addAttachment(key, value);
            }
            super.defaultExecution(token);
        }
    }

    protected void endTimeAssignments(Token token) {
        if (this.receivedMessages.size() > 0) {
            super.endTimeAssignments(token);
        }
    }

    protected synchronized void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        if (this.receivedMessages.size() > 0) {
            this.receivedMessages.remove(0);
            tokenExecutor.move(token, this.getOutFlow());
        } else {
            tokenExecutor.suspend(token);
            ExecutionContext exContext = token.getExecutionContext();
            exContext.addAttachment(TokenExecutor.class, (Object)tokenExecutor);
            this.suspendedTokens.add(token);
        }
    }

    protected void create(Process proc) {
        super.create(proc);
        if (this.messageRef == null) {
            throw new InvalidProcessException("A Message for the MessageRef attribute MUST be entered");
        }
        ProcessImpl procImpl = (ProcessImpl)proc;
        procImpl.initializeMessageRef(this.messageRef);
    }
}

