/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.saml.elytron.ElytronHttpFacade;
import org.keycloak.adapters.saml.elytron.ElytronTokeStore;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.Scope;

public class ElytronSamlSessionStore
implements SamlSessionStore,
ElytronTokeStore {
    protected static Logger log = Logger.getLogger(SamlSessionStore.class);
    public static final String SAML_REDIRECT_URI = "SAML_REDIRECT_URI";
    private final SessionIdMapper idMapper;
    private final SessionIdMapperUpdater idMapperUpdater;
    protected final SamlDeployment deployment;
    private final ElytronHttpFacade exchange;

    public ElytronSamlSessionStore(ElytronHttpFacade exchange, SessionIdMapper idMapper, SessionIdMapperUpdater idMapperUpdater, SamlDeployment deployment) {
        this.exchange = exchange;
        this.idMapper = idMapper;
        this.idMapperUpdater = idMapperUpdater;
        this.deployment = deployment;
    }

    public void setCurrentAction(SamlSessionStore.CurrentAction action) {
        if (action == SamlSessionStore.CurrentAction.NONE && !this.exchange.getScope(Scope.SESSION).exists()) {
            return;
        }
        this.exchange.getScope(Scope.SESSION).setAttachment("SAML_CURRENT_ACTION", (Object)action);
    }

    public boolean isLoggingIn() {
        HttpScope session = this.exchange.getScope(Scope.SESSION);
        if (!session.exists()) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttachment("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_IN;
    }

    public boolean isLoggingOut() {
        HttpScope session = this.exchange.getScope(Scope.SESSION);
        if (!session.exists()) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttachment("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_OUT;
    }

    public void logoutAccount() {
        HttpScope session = this.getSession(false);
        if (session.exists()) {
            log.debug((Object)"Logging out - current account");
            SamlSession samlSession = (SamlSession)session.getAttachment(SamlSession.class.getName());
            if (samlSession != null) {
                if (samlSession.getSessionIndex() != null) {
                    this.idMapperUpdater.removeSession(this.idMapper, session.getID());
                }
                session.setAttachment(SamlSession.class.getName(), null);
            }
            session.setAttachment(SAML_REDIRECT_URI, null);
        }
    }

    public void logoutByPrincipal(String principal) {
        Set sessions = this.idMapper.getUserSessions(principal);
        if (sessions != null) {
            log.debugf("Logging out - by principal: %s", (Object)sessions);
            LinkedList<String> ids = new LinkedList<String>();
            ids.addAll(sessions);
            this.logoutSessionIds(ids);
            for (String id : ids) {
                this.idMapperUpdater.removeSession(this.idMapper, id);
            }
        }
    }

    public void logoutBySsoId(List<String> ssoIds) {
        if (ssoIds == null) {
            return;
        }
        log.debugf("Logging out - by session IDs: %s", ssoIds);
        LinkedList<String> sessionIds = new LinkedList<String>();
        for (String id : ssoIds) {
            String sessionId = this.idMapper.getSessionFromSSO(id);
            if (sessionId == null) continue;
            sessionIds.add(sessionId);
            this.idMapperUpdater.removeSession(this.idMapper, sessionId);
        }
        this.logoutSessionIds(sessionIds);
    }

    protected void logoutSessionIds(List<String> sessionIds) {
        sessionIds.forEach(id -> {
            HttpScope scope = this.exchange.getScope(Scope.SESSION, (String)id);
            if (scope.exists()) {
                log.debugf("Invalidating session %s", id);
                scope.setAttachment(SamlSession.class.getName(), null);
                scope.invalidate();
            }
        });
    }

    public boolean isLoggedIn() {
        HttpScope session = this.getSession(false);
        if (!session.exists()) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        if (!this.idMapper.hasSession(session.getID()) && !this.idMapperUpdater.refreshMapping(this.idMapper, session.getID())) {
            log.debugf("Session %s has expired on some other node", (Object)session.getID());
            session.setAttachment(SamlSession.class.getName(), null);
            return false;
        }
        SamlSession samlSession = SamlUtil.validateSamlSession((Object)session.getAttachment(SamlSession.class.getName()), (SamlDeployment)this.deployment);
        if (samlSession == null) {
            return false;
        }
        this.exchange.authenticationComplete(samlSession);
        this.restoreRequest();
        return true;
    }

    public void saveAccount(SamlSession account) {
        HttpScope session = this.getSession(true);
        session.setAttachment(SamlSession.class.getName(), (Object)account);
        String sessionId = this.changeSessionId(session);
        this.idMapperUpdater.map(this.idMapper, account.getSessionIndex(), account.getPrincipal().getSamlSubject(), sessionId);
    }

    protected String changeSessionId(HttpScope session) {
        if (!this.deployment.turnOffChangeSessionIdOnLogin()) {
            return session.getID();
        }
        return session.getID();
    }

    public SamlSession getAccount() {
        HttpScope session = this.getSession(true);
        return (SamlSession)session.getAttachment(SamlSession.class.getName());
    }

    public String getRedirectUri() {
        HttpScope session = this.exchange.getScope(Scope.SESSION);
        String redirect = (String)session.getAttachment(SAML_REDIRECT_URI);
        if (redirect == null) {
            String relativePath;
            URI uri = this.exchange.getURI();
            String path = uri.getPath();
            String contextPath = path.substring(0, path.indexOf(relativePath = this.exchange.getRequest().getRelativePath()));
            if (!contextPath.isEmpty()) {
                contextPath = contextPath + "/";
            }
            String baseUri = KeycloakUriBuilder.fromUri((String)path).replacePath(contextPath).build(new Object[0]).toString();
            return SamlUtil.getRedirectTo((HttpFacade)this.exchange, (String)contextPath, (String)baseUri);
        }
        return redirect;
    }

    public void saveRequest() {
        this.exchange.suspendRequest();
        HttpScope scope = this.exchange.getScope(Scope.SESSION);
        if (!scope.exists()) {
            scope.create();
        }
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((URI)this.exchange.getURI()).replaceQuery(this.exchange.getURI().getQuery());
        String uri = uriBuilder.build(new Object[0]).toString();
        scope.setAttachment(SAML_REDIRECT_URI, (Object)uri);
    }

    public boolean restoreRequest() {
        return this.exchange.restoreRequest();
    }

    protected HttpScope getSession(boolean create) {
        HttpScope scope = this.exchange.getScope(Scope.SESSION);
        if (!scope.exists() && create) {
            scope.create();
        }
        return scope;
    }

    @Override
    public void logout(boolean glo) {
        this.logoutAccount();
    }
}

