/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.metadata.AffiliationDescriptorType;
import org.keycloak.dom.saml.v2.metadata.AttributeAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.AuthnAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.ContactType;
import org.keycloak.dom.saml.v2.metadata.ContactTypeType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.metadata.LocalizedURIType;
import org.keycloak.dom.saml.v2.metadata.OrganizationType;
import org.keycloak.dom.saml.v2.metadata.PDPDescriptorType;
import org.keycloak.dom.saml.v2.metadata.RequestedAttributeType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.BaseWriter;
import org.w3c.dom.Element;

public class SAMLMetadataWriter
extends BaseWriter {
    private final String METADATA_PREFIX = "md";

    public SAMLMetadataWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void writeEntitiesDescriptor(EntitiesDescriptorType entities) throws ProcessingException {
        ExtensionsType extensions;
        Element signature;
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ENTITIES_DESCRIPTOR.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "md", JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "saml", JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "ds", JBossSAMLURIConstants.XMLDSIG_NSURI.get());
        if (entities.getValidUntil() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VALID_UNTIL.get(), entities.getValidUntil().toString());
        }
        if (entities.getID() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), entities.getID());
        }
        if (entities.getName() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NAME.get(), entities.getName());
        }
        if ((signature = entities.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, signature);
        }
        if ((extensions = entities.getExtensions()) != null) {
            StaxUtil.writeDOMElement(this.writer, extensions.getElement());
        }
        List entityDescriptors = entities.getEntityDescriptor();
        for (Object ed : entityDescriptors) {
            if (ed instanceof EntityDescriptorType) {
                this.writeEntityDescriptor((EntityDescriptorType)ed);
                continue;
            }
            this.writeEntitiesDescriptor((EntitiesDescriptorType)ed);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeEntityDescriptor(EntityDescriptorType entityDescriptor) throws ProcessingException {
        ExtensionsType extensions;
        Element signature;
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ENTITY_DESCRIPTOR.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "md", JBossSAMLURIConstants.METADATA_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "saml", JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "ds", JBossSAMLURIConstants.XMLDSIG_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ENTITY_ID.get(), entityDescriptor.getEntityID());
        if (entityDescriptor.getValidUntil() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VALID_UNTIL.get(), entityDescriptor.getValidUntil().toString());
        }
        if (entityDescriptor.getID() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), entityDescriptor.getID());
        }
        if ((signature = entityDescriptor.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, signature);
        }
        if ((extensions = entityDescriptor.getExtensions()) != null) {
            StaxUtil.writeDOMElement(this.writer, extensions.getElement());
        }
        List choiceTypes = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edtChoice : choiceTypes) {
            AffiliationDescriptorType affliationDesc = edtChoice.getAffiliationDescriptor();
            if (affliationDesc != null) {
                throw logger.notImplementedYet("affliation");
            }
            List edtDescChoices = edtChoice.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDescChoice : edtDescChoices) {
                AuthnAuthorityDescriptorType authNDesc;
                AttributeAuthorityDescriptorType attribAuth;
                SPSSODescriptorType spSSO;
                RoleDescriptorType roleDesc = edtDescChoice.getRoleDescriptor();
                if (roleDesc != null) {
                    throw logger.notImplementedYet("Role Descriptor type");
                }
                IDPSSODescriptorType idpSSO = edtDescChoice.getIdpDescriptor();
                if (idpSSO != null) {
                    this.write(idpSSO);
                }
                if ((spSSO = edtDescChoice.getSpDescriptor()) != null) {
                    this.write(spSSO);
                }
                if ((attribAuth = edtDescChoice.getAttribDescriptor()) != null) {
                    this.writeAttributeAuthorityDescriptor(attribAuth);
                }
                if ((authNDesc = edtDescChoice.getAuthnDescriptor()) != null) {
                    throw logger.notImplementedYet("AuthnAuthorityDescriptorType");
                }
                PDPDescriptorType pdpDesc = edtDescChoice.getPdpDescriptor();
                if (pdpDesc == null) continue;
                throw logger.notImplementedYet("PDPDescriptorType");
            }
        }
        OrganizationType organization = entityDescriptor.getOrganization();
        if (organization != null) {
            this.writeOrganization(organization);
        }
        List contactPersons = entityDescriptor.getContactPerson();
        for (ContactType contact : contactPersons) {
            this.write(contact);
        }
        List addl = entityDescriptor.getAdditionalMetadataLocation();
        if (addl.size() > 0) {
            throw logger.notImplementedYet("AdditionalMetadataLocationType");
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SSODescriptorType ssoDescriptor) throws ProcessingException {
        throw new RuntimeException("should not be called");
    }

    public void write(SPSSODescriptorType spSSODescriptor) throws ProcessingException {
        Boolean wantAssertionsSigned;
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.SP_SSO_DESCRIPTOR.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeProtocolSupportEnumeration(spSSODescriptor.getProtocolSupportEnumeration());
        Boolean authnSigned = spSSODescriptor.isAuthnRequestsSigned();
        if (authnSigned != null) {
            StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLConstants.AUTHN_REQUESTS_SIGNED.get()), authnSigned.toString());
        }
        if ((wantAssertionsSigned = spSSODescriptor.isWantAssertionsSigned()) != null) {
            StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLConstants.WANT_ASSERTIONS_SIGNED.get()), wantAssertionsSigned.toString());
        }
        List keyDescriptors = spSSODescriptor.getKeyDescriptor();
        for (Object keyDescriptor : keyDescriptors) {
            this.writeKeyDescriptor((KeyDescriptorType)keyDescriptor);
        }
        List sloServices = spSSODescriptor.getSingleLogoutService();
        for (Object endpoint : sloServices) {
            this.writeSingleLogoutService((EndpointType)endpoint);
        }
        List artifactResolutions = spSSODescriptor.getArtifactResolutionService();
        for (Object artifactResolution : artifactResolutions) {
            this.writeArtifactResolutionService((IndexedEndpointType)artifactResolution);
        }
        List nameIDFormats = spSSODescriptor.getNameIDFormat();
        for (Object nameIDFormat : nameIDFormats) {
            this.writeNameIDFormat((String)nameIDFormat);
        }
        List assertionConsumers = spSSODescriptor.getAssertionConsumerService();
        for (IndexedEndpointType assertionConsumer : assertionConsumers) {
            this.writeAssertionConsumerService(assertionConsumer);
        }
        List attributeConsumers = spSSODescriptor.getAttributeConsumingService();
        for (AttributeConsumingServiceType attributeConsumer : attributeConsumers) {
            this.writeAttributeConsumingService(attributeConsumer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(IDPSSODescriptorType idpSSODescriptor) throws ProcessingException {
        if (idpSSODescriptor == null) {
            throw new ProcessingException((Throwable)logger.nullArgumentError("IDPSSODescriptorType"));
        }
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.IDP_SSO_DESCRIPTOR.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        Boolean wantsAuthnRequestsSigned = idpSSODescriptor.isWantAuthnRequestsSigned();
        if (wantsAuthnRequestsSigned != null) {
            StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLConstants.WANT_AUTHN_REQUESTS_SIGNED.get()), wantsAuthnRequestsSigned.toString());
        }
        this.writeProtocolSupportEnumeration(idpSSODescriptor.getProtocolSupportEnumeration());
        List keyDescriptors = idpSSODescriptor.getKeyDescriptor();
        for (Object keyDescriptor : keyDescriptors) {
            this.writeKeyDescriptor((KeyDescriptorType)keyDescriptor);
        }
        List artifactResolutionServices = idpSSODescriptor.getArtifactResolutionService();
        for (Object indexedEndpoint : artifactResolutionServices) {
            this.writeArtifactResolutionService((IndexedEndpointType)indexedEndpoint);
        }
        List sloServices = idpSSODescriptor.getSingleLogoutService();
        for (Object endpoint : sloServices) {
            this.writeSingleLogoutService((EndpointType)endpoint);
        }
        List nameIDFormats = idpSSODescriptor.getNameIDFormat();
        for (Object nameIDFormat : nameIDFormats) {
            this.writeNameIDFormat((String)nameIDFormat);
        }
        List ssoServices = idpSSODescriptor.getSingleSignOnService();
        for (EndpointType endpoint : ssoServices) {
            this.writeSingleSignOnService(endpoint);
        }
        List attributes = idpSSODescriptor.getAttribute();
        for (AttributeType attribType : attributes) {
            this.write(attribType);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeAttributeAuthorityDescriptor(AttributeAuthorityDescriptorType attributeAuthority) throws ProcessingException {
        ExtensionsType extensions;
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ATTRIBUTE_AUTHORITY_DESCRIPTOR.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeProtocolSupportEnumeration(attributeAuthority.getProtocolSupportEnumeration());
        Element signature = attributeAuthority.getSignature();
        if (signature != null) {
            StaxUtil.writeDOMElement(this.writer, signature);
        }
        if ((extensions = attributeAuthority.getExtensions()) != null) {
            StaxUtil.writeDOMElement(this.writer, extensions.getElement());
        }
        List keyDescriptorList = attributeAuthority.getKeyDescriptor();
        for (Object keyDescriptor : keyDescriptorList) {
            this.writeKeyDescriptor((KeyDescriptorType)keyDescriptor);
        }
        List attributeServices = attributeAuthority.getAttributeService();
        for (Object endpoint : attributeServices) {
            this.writeAttributeService((EndpointType)endpoint);
        }
        List nameIDFormats = attributeAuthority.getNameIDFormat();
        for (String nameIDFormat : nameIDFormats) {
            this.writeNameIDFormat(nameIDFormat);
        }
        List attributes = attributeAuthority.getAttribute();
        for (AttributeType attributeType : attributes) {
            this.write(attributeType);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeArtifactResolutionService(IndexedEndpointType indexedEndpoint) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ARTIFACT_RESOLUTION_SERVICE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeIndexedEndpointType(indexedEndpoint);
    }

    public void writeAssertionConsumerService(IndexedEndpointType indexedEndpoint) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeIndexedEndpointType(indexedEndpoint);
    }

    public void writeIndexedEndpointType(IndexedEndpointType indexedEndpoint) throws ProcessingException {
        this.writeEndpointType((EndpointType)indexedEndpoint);
        if (indexedEndpoint.isIsDefault() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISDEFAULT.get(), "" + indexedEndpoint.isIsDefault());
        }
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.INDEX.get(), "" + indexedEndpoint.getIndex());
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeAttributeConsumingService(AttributeConsumingServiceType attributeConsumer) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        if (attributeConsumer.isIsDefault() != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISDEFAULT.get(), "" + attributeConsumer.isIsDefault());
        }
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.INDEX.get(), "" + attributeConsumer.getIndex());
        List serviceNames = attributeConsumer.getServiceName();
        for (Object serviceName : serviceNames) {
            this.writeLocalizedNameType((LocalizedNameType)serviceName, new QName(JBossSAMLURIConstants.METADATA_NSURI.get(), JBossSAMLConstants.SERVICE_NAME.get(), "md"));
        }
        List serviceDescriptions = attributeConsumer.getServiceDescription();
        for (LocalizedNameType serviceDescription : serviceDescriptions) {
            this.writeLocalizedNameType(serviceDescription, new QName(JBossSAMLURIConstants.METADATA_NSURI.get(), JBossSAMLConstants.SERVICE_DESCRIPTION.get(), "md"));
        }
        List requestedAttributes = attributeConsumer.getRequestedAttribute();
        for (RequestedAttributeType requestedAttribute : requestedAttributes) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.REQUESTED_ATTRIBUTE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            Boolean isRequired = requestedAttribute.isIsRequired();
            if (isRequired != null) {
                StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLConstants.IS_REQUIRED.get()), isRequired.toString());
            }
            this.writeAttributeTypeWithoutRootTag((AttributeType)requestedAttribute);
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeOrganization(OrganizationType org) throws ProcessingException {
        if (org == null) {
            throw new ProcessingException((Throwable)logger.nullArgumentError("Organization"));
        }
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ORGANIZATION.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        ExtensionsType extensions = org.getExtensions();
        if (extensions != null) {
            StaxUtil.writeDOMElement(this.writer, extensions.getElement());
        }
        List nameList = org.getOrganizationName();
        for (Object localName : nameList) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ORGANIZATION_NAME.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            this.writeLocalizedType((LocalizedNameType)localName);
        }
        List displayNameList = org.getOrganizationDisplayName();
        for (LocalizedNameType localName : displayNameList) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ORGANIZATION_DISPLAY_NAME.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            this.writeLocalizedType(localName);
        }
        List uriList = org.getOrganizationURL();
        for (LocalizedURIType uri : uriList) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ORGANIZATION_URL.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            String lang = uri.getLang();
            String val = uri.getValue().toString();
            StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XML.get(), JBossSAMLConstants.LANG.get(), "xml"), lang);
            StaxUtil.writeCharacters(this.writer, val);
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(ContactType contact) throws ProcessingException {
        String surName;
        String givenName;
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.CONTACT_PERSON.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        ExtensionsType extensions = contact.getExtensions();
        if (extensions != null) {
            StaxUtil.writeDOMElement(this.writer, extensions.getElement());
        }
        ContactTypeType attribs = contact.getContactType();
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONTACT_TYPE.get(), attribs.value());
        String company = contact.getCompany();
        if (company != null) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.COMPANY.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters(this.writer, company);
            StaxUtil.writeEndElement(this.writer);
        }
        if ((givenName = contact.getGivenName()) != null) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.GIVEN_NAME.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters(this.writer, givenName);
            StaxUtil.writeEndElement(this.writer);
        }
        if ((surName = contact.getSurName()) != null) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.SURNAME.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters(this.writer, surName);
            StaxUtil.writeEndElement(this.writer);
        }
        List emailAddresses = contact.getEmailAddress();
        for (String email : emailAddresses) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.EMAIL_ADDRESS.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters(this.writer, email);
            StaxUtil.writeEndElement(this.writer);
        }
        List tels = contact.getTelephoneNumber();
        for (String telephone : tels) {
            StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.TELEPHONE_NUMBER.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
            StaxUtil.writeCharacters(this.writer, telephone);
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeKeyDescriptor(KeyDescriptorType keyDescriptor) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.KEY_DESCRIPTOR.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        KeyTypes keyTypes = keyDescriptor.getUse();
        if (keyTypes != null) {
            StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLConstants.USE.get()), keyTypes.value());
        }
        Element keyInfo = keyDescriptor.getKeyInfo();
        StaxUtil.writeDOMElement(this.writer, keyInfo);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeAttributeService(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.ATTRIBUTE_SERVICE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeEndpointType(endpoint);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeSingleLogoutService(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.SINGLE_LOGOUT_SERVICE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeEndpointType(endpoint);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void writeSingleSignOnService(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.SINGLE_SIGNON_SERVICE.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        this.writeEndpointType(endpoint);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    private void writeProtocolSupportEnumeration(List<String> protoEnum) throws ProcessingException {
        if (protoEnum.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String str : protoEnum) {
                sb.append(str).append(" ");
            }
            StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLConstants.PROTOCOL_SUPPORT_ENUMERATION.get()), sb.toString().trim());
        }
    }

    private void writeEndpointType(EndpointType endpoint) throws ProcessingException {
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.BINDING.get(), endpoint.getBinding().toString());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.LOCATION.get(), endpoint.getLocation().toString());
        URI responseLocation = endpoint.getResponseLocation();
        if (responseLocation != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.RESPONSE_LOCATION.get(), responseLocation.toString());
        }
    }

    private void writeLocalizedType(LocalizedNameType localName) throws ProcessingException {
        String lang = localName.getLang();
        String val = localName.getValue();
        StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XML.get(), JBossSAMLConstants.LANG.get(), "xml"), lang);
        StaxUtil.writeCharacters(this.writer, val);
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeNameIDFormat(String nameIDFormat) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "md", JBossSAMLConstants.NAMEID_FORMAT.get(), JBossSAMLURIConstants.METADATA_NSURI.get());
        if (nameIDFormat != null) {
            StaxUtil.writeCharacters(this.writer, nameIDFormat);
        }
        StaxUtil.writeEndElement(this.writer);
    }
}

