/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.authenticator;

import java.net.URI;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.util.CookieHelper;

public class SecretQuestionAuthenticator
implements Authenticator {
    public static final String CREDENTIAL_TYPE = "secret_question";

    protected boolean hasCookie(AuthenticationFlowContext context) {
        boolean result;
        Cookie cookie = (Cookie)context.getHttpRequest().getHttpHeaders().getCookies().get("SECRET_QUESTION_ANSWERED");
        boolean bl = result = cookie != null;
        if (result) {
            System.out.println("Bypassing secret question because cookie as set");
        }
        return result;
    }

    public void authenticate(AuthenticationFlowContext context) {
        if (this.hasCookie(context)) {
            context.success();
            return;
        }
        Response challenge = context.form().createForm("secret-question.ftl");
        context.challenge(challenge);
    }

    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.cancelLogin();
            return;
        }
        boolean validated = this.validateAnswer(context);
        if (!validated) {
            Response challenge = context.form().setError("badSecret", new Object[0]).createForm("secret-question.ftl");
            context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challenge);
            return;
        }
        this.setCookie(context);
        context.success();
    }

    protected void setCookie(AuthenticationFlowContext context) {
        AuthenticatorConfigModel config = context.getAuthenticatorConfig();
        int maxCookieAge = 2592000;
        if (config != null) {
            maxCookieAge = Integer.valueOf((String)config.getConfig().get("cookie.max.age"));
        }
        URI uri = context.getUriInfo().getBaseUriBuilder().path("realms").path(context.getRealm().getName()).build(new Object[0]);
        CookieHelper.addCookie((String)"SECRET_QUESTION_ANSWERED", (String)"true", (String)uri.getRawPath(), null, null, (int)maxCookieAge, (boolean)false, (boolean)true);
    }

    protected boolean validateAnswer(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String secret = (String)formData.getFirst((Object)"secret_answer");
        UserCredentialValueModel cred = null;
        for (UserCredentialValueModel model : context.getUser().getCredentialsDirectly()) {
            if (!model.getType().equals(CREDENTIAL_TYPE)) continue;
            cred = model;
            break;
        }
        return cred.getValue().equals(secret);
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.users().configuredForCredentialType(CREDENTIAL_TYPE, realm, user);
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        user.addRequiredAction("secret_question_config");
    }

    public void close() {
    }
}

