/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.common.util.UriUtils;
import org.keycloak.example.oauth.DatabaseClient;
import org.keycloak.example.oauth.ServletRequestQualifier;
import org.keycloak.example.oauth.UserData;
import org.keycloak.servlet.ServletOAuthClient;
import org.keycloak.util.JsonSerialization;

@ApplicationScoped
@Named(value="databaseClient")
public class DatabaseClient {
    @Inject
    @ServletRequestQualifier
    private HttpServletRequest request;
    @Inject
    private HttpServletResponse response;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ServletOAuthClient oauthClient;
    @Inject
    private UserData userData;
    private static final Logger logger = Logger.getLogger(DatabaseClient.class);

    public void retrieveAccessToken() {
        try {
            this.oauthClient.redirectRelative("client.jsf", this.request, this.response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendCustomersRequest() {
        List customers = this.sendRequestToDBApplication(this.getBaseUrl() + "/database/customers");
        this.userData.setCustomers(customers);
    }

    public void sendProductsRequest() {
        List products = this.sendRequestToDBApplication(this.getBaseUrl() + "/database/products");
        this.userData.setProducts(products);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> sendRequestToDBApplication(String dbUri) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(dbUri);
        try {
            if (this.userData.isHasAccessToken()) {
                get.addHeader("Authorization", "Bearer " + this.userData.getAccessToken());
            }
            HttpResponse response = client.execute((HttpUriRequest)get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    HttpEntity entity = response.getEntity();
                    try (InputStream is = entity.getContent();){
                        List list = (List)JsonSerialization.readValue((InputStream)is, TypedList.class);
                        return list;
                    }
                }
                case 401: {
                    this.facesContext.addMessage(null, new FacesMessage("Status: 401. Request not authenticated! You need to retrieve access token first."));
                    return null;
                }
                case 403: {
                    this.facesContext.addMessage(null, new FacesMessage("Status: 403. Access token has insufficient privileges"));
                    return null;
                }
            }
            this.facesContext.addMessage(null, new FacesMessage("Status: " + response.getStatusLine() + ". Not able to retrieve data. See log for details"));
            logger.warn((Object)("Error occured. Status: " + response.getStatusLine()));
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.facesContext.addMessage(null, new FacesMessage("Unknown error. See log for details"));
            return null;
        }
    }

    public String getBaseUrl() {
        KeycloakSecurityContext session = (KeycloakSecurityContext)this.request.getAttribute(KeycloakSecurityContext.class.getName());
        return UriUtils.getOrigin((String)this.request.getRequestURL().toString());
    }
}

