/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.oauth;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.example.oauth.UserData;
import org.keycloak.servlet.ServletOAuthClient;

@WebFilter(value={"/client.jsf"})
public class RefreshTokenFilter
implements Filter {
    public static final String OAUTH_ERROR_ATTR = "oauthErrorAttr";
    @Inject
    private ServletOAuthClient oauthClient;
    @Inject
    private UserData userData;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        Map reqParams = request.getParameterMap();
        if (reqParams.containsKey("code")) {
            try {
                String accessToken = this.oauthClient.getBearerToken(request).getToken();
                this.userData.setAccessToken(accessToken);
            }
            catch (ServerRequest.HttpFailure e) {
                throw new ServletException((Throwable)e);
            }
        } else if (reqParams.containsKey("error")) {
            String oauthError = ((String[])reqParams.get("error"))[0];
            request.setAttribute(OAUTH_ERROR_ATTR, (Object)oauthError);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

